"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderParameterTemplates = void 0;
var _mustache_renderer = require("@kbn/actions-plugin/server/lib/mustache_renderer");
var _constants = require("../../../common/thehive/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapSeverity(severity) {
  switch (severity) {
    case 'low':
      return 1;
    case 'medium':
      return 2;
    case 'high':
      return 3;
    case 'critical':
      return 4;
    default:
      return 2;
  }
}
const renderParameterTemplates = (logger, params, variables) => {
  if ((params === null || params === void 0 ? void 0 : params.subAction) === _constants.SUB_ACTION.PUSH_TO_SERVICE) {
    return (0, _mustache_renderer.renderMustacheObject)(logger, params, variables);
  } else {
    return {
      ...params,
      subActionParams: {
        ...(0, _mustache_renderer.renderMustacheObject)(logger, params.subActionParams, variables),
        severity: params.subActionParams.isRuleSeverity === true ? mapSeverity((0, _mustache_renderer.renderMustacheString)(logger, '{{context.rule.severity}}', variables, 'json')) : params.subActionParams.severity
      }
    };
  }
};
exports.renderParameterTemplates = renderParameterTemplates;