"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrowdStrikeSessionManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _schema = require("../../../common/crowdstrike/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CrowdStrikeSessionManager {
  constructor(urls, apiRequest) {
    (0, _defineProperty2.default)(this, "currentBatchId", null);
    (0, _defineProperty2.default)(this, "refreshInterval", null);
    (0, _defineProperty2.default)(this, "closeSessionTimeout", null);
    this.urls = urls;
    this.apiRequest = apiRequest;
  }
  async initializeSession(payload, connectorUsageCollector) {
    if (!this.currentBatchId) {
      // Make a request to initialize the session
      const response = await this.apiRequest({
        url: this.urls.batchInitRTRSession,
        method: 'post',
        data: {
          host_ids: payload.endpoint_ids
        },
        responseSchema: _schema.CrowdstrikeInitRTRResponseSchema
      }, connectorUsageCollector);
      this.currentBatchId = response.batch_id;

      // Start the refresh interval
      this.startRefreshInterval(connectorUsageCollector);
    }

    // Reset the close session timeout
    this.resetCloseSessionTimeout();
    return this.currentBatchId;
  }
  startRefreshInterval(connectorUsageCollector) {
    if (this.refreshInterval) {
      clearInterval(this.refreshInterval);
    }
    this.refreshInterval = setInterval(() => {
      this.refreshSession(connectorUsageCollector).catch(() => {});
    }, 5 * 60 * 1000); // Refresh every 5 minutes
  }
  async refreshSession(connectorUsageCollector) {
    await this.apiRequest({
      url: this.urls.batchRefreshRTRSession,
      method: 'post',
      data: {
        batch_id: this.currentBatchId
      },
      responseSchema: _schema.CrowdstrikeInitRTRResponseSchema
    }, connectorUsageCollector);
  }
  resetCloseSessionTimeout() {
    if (this.closeSessionTimeout) {
      clearTimeout(this.closeSessionTimeout);
    }
    this.closeSessionTimeout = setTimeout(() => {
      this.terminateSession().catch(() => {});
    }, 10 * 60 * 1000); // Close session after 10 minutes of inactivity
  }
  async terminateSession() {
    // Clear intervals and timeouts
    if (this.refreshInterval) {
      clearInterval(this.refreshInterval);
      this.refreshInterval = null;
    }
    if (this.closeSessionTimeout) {
      clearTimeout(this.closeSessionTimeout);
      this.closeSessionTimeout = null;
    }
  }
}
exports.CrowdStrikeSessionManager = CrowdStrikeSessionManager;