"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _schema = require("./schema");
var _schema_utils = require("../schema_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JsonEditorComponent = ({
  editAction,
  index,
  messageVariables,
  subActionParams
}) => {
  const [jsonEditorErrors, setJsonEditorErrors] = (0, _react.useState)([]);
  const jsonEditorValue = (0, _react.useMemo)(() => getJsonEditorValue(subActionParams), [subActionParams]);
  const decodeJsonWithSchema = (0, _react.useCallback)(jsonBlob => {
    try {
      const decodedValue = (0, _schema.decodeCreateAlert)(jsonBlob);
      setJsonEditorErrors([]);
      return decodedValue;
    } catch (error) {
      if ((0, _schema_utils.isDecodeError)(error)) {
        setJsonEditorErrors(error.decodeErrors);
      } else {
        setJsonEditorErrors([error.message]);
      }
      return;
    }
  }, []);
  const onAdvancedEditorChange = (0, _react.useCallback)(json => {
    const parsedJson = parseJson(json);
    if (!parsedJson) {
      editAction('jsonEditorError', true, index);
      return;
    }
    const decodedValue = decodeJsonWithSchema(parsedJson);
    if (!decodedValue) {
      editAction('jsonEditorError', true, index);
      return;
    }
    editAction('subActionParams', decodedValue, index);
  }, [editAction, index, decodeJsonWithSchema]);
  (0, _react.useEffect)(() => {
    // show the initial error messages
    const decodedValue = decodeJsonWithSchema(subActionParams !== null && subActionParams !== void 0 ? subActionParams : {});
    if (!decodedValue) {
      editAction('jsonEditorError', true, index);
    } else {
      // must mark as undefined to remove the field so it is not sent to the server side
      editAction('jsonEditorError', undefined, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [subActionParams, decodeJsonWithSchema, index]);
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'subActionParams',
    inputTargetValue: jsonEditorValue,
    ariaLabel: i18n.JSON_EDITOR_ARIA,
    onDocumentsChange: onAdvancedEditorChange,
    errors: jsonEditorErrors,
    label: i18n.ALERT_FIELDS_LABEL,
    dataTestSubj: "actionJsonEditor"
  });
};
JsonEditorComponent.displayName = 'JsonEditor';
const JsonEditor = exports.default = /*#__PURE__*/_react.default.memo(JsonEditorComponent);

// eslint-disable-next-line import/no-default-export

const parseJson = jsonValue => {
  try {
    return JSON.parse(jsonValue);
  } catch (error) {
    return;
  }
};
const getJsonEditorValue = subActionParams => {
  const defaultValue = '{}';
  try {
    const value = JSON.stringify(subActionParams, null, 2);
    if ((0, _lodash.isEmpty)(value)) {
      return defaultValue;
    }
    return value;
  } catch (error) {
    return defaultValue;
  }
};
module.exports = exports.default;