"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalFieldsComponent = exports.AdditionalFields = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdditionalFieldsComponent = ({
  value,
  errors,
  messageVariables,
  onChange,
  isOptionalField = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'additional_fields',
    inputTargetValue: value,
    errors: errors !== null && errors !== void 0 ? errors : [],
    dataTestSubj: "additionalFields",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ADDITIONAL_FIELDS, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      "data-test-subj": "otherFieldsHelpTooltip",
      "aria-label": i18n.ADDITIONAL_FIELDS_HELP,
      content: i18n.ADDITIONAL_FIELDS_HELP_TEXT
    })),
    onDocumentsChange: json => onChange((0, _lodash.isEmpty)(json) ? null : json),
    isOptionalField: isOptionalField
  });
};
exports.AdditionalFieldsComponent = AdditionalFieldsComponent;
const AdditionalFields = exports.AdditionalFields = /*#__PURE__*/_react.default.memo(AdditionalFieldsComponent);