"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _validator = require("../validator");
var _action_variables = require("../action_variables");
var _webhook_connectors = require("../webhook_connectors");
var _update = require("./update.styles");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const UpdateStep = ({
  display,
  readOnly
}) => {
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const hasCommentDefaultValue = !!getFieldDefaultValue('config.createCommentUrl') || !!getFieldDefaultValue('config.createCommentJson');
  const [isAddCommentToggled, setIsAddCommentToggled] = (0, _react.useState)(Boolean(hasCommentDefaultValue));
  const onAddCommentToggle = () => {
    setIsAddCommentToggled(prev => !prev);
  };
  const updateIncidentMethodConfig = (0, _react.useMemo)(() => ({
    label: i18n.UPDATE_INCIDENT_METHOD,
    defaultValue: 'put',
    type: _hook_form_lib.FIELD_TYPES.SELECT,
    validations: [{
      validator: emptyField(i18n.UPDATE_METHOD_REQUIRED)
    }]
  }), []);
  const updateIncidentUrlConfig = (0, _react.useMemo)(() => ({
    label: i18n.UPDATE_INCIDENT_URL,
    validations: [{
      validator: urlField(i18n.UPDATE_URL_REQUIRED)
    }],
    helpText: i18n.UPDATE_INCIDENT_URL_HELP
  }), []);
  const updateIncidentJsonConfig = (0, _react.useMemo)(() => ({
    label: i18n.UPDATE_INCIDENT_JSON,
    helpText: i18n.UPDATE_INCIDENT_JSON_HELP,
    validations: [{
      validator: emptyField(i18n.UPDATE_INCIDENT_REQUIRED)
    }, {
      validator: (0, _validator.containsTitleAndDesc)()
    }]
  }), []);
  const createCommentMethodConfig = (0, _react.useMemo)(() => ({
    label: i18n.CREATE_COMMENT_METHOD,
    defaultValue: 'put',
    type: _hook_form_lib.FIELD_TYPES.SELECT,
    validations: [{
      validator: emptyField(i18n.CREATE_COMMENT_METHOD_REQUIRED)
    }]
  }), []);
  const createCommentUrlConfig = (0, _react.useMemo)(() => ({
    label: i18n.CREATE_COMMENT_URL,
    fieldsToValidateOnChange: ['config.createCommentUrl', 'config.createCommentJson'],
    validations: [{
      validator: (0, _validator.isUrlButCanBeEmpty)(i18n.CREATE_COMMENT_URL_FORMAT_REQUIRED)
    }, {
      validator: (0, _validator.validateCreateComment)(i18n.CREATE_COMMENT_URL_MISSING, 'config.createCommentJson')
    }],
    helpText: i18n.CREATE_COMMENT_URL_HELP
  }), []);
  const createCommentJsonConfig = (0, _react.useMemo)(() => ({
    label: i18n.CREATE_COMMENT_JSON,
    helpText: i18n.CREATE_COMMENT_JSON_HELP,
    fieldsToValidateOnChange: ['config.createCommentJson', 'config.createCommentUrl'],
    validations: [{
      validator: (0, _validator.containsCommentsOrEmpty)(i18n.CREATE_COMMENT_FORMAT_MESSAGE)
    }, {
      validator: (0, _validator.validateCreateComment)(i18n.CREATE_COMMENT_JSON_MISSING, 'config.createCommentUrl')
    }]
  }), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "updateStep",
    style: {
      display: display ? 'block' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, i18n.STEP_4A), /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.STEP_4A_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.updateIncidentMethod",
    component: _components.Field,
    config: updateIncidentMethodConfig,
    css: _update.styles.method,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookUpdateMethodSelect',
        options: _webhook_connectors.HTTP_VERBS.map(verb => ({
          text: verb.toUpperCase(),
          value: verb
        })),
        readOnly
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.updateIncidentUrl",
    config: updateIncidentUrlConfig,
    component: _public.MustacheTextFieldWrapper,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'webhookUpdateUrlText',
        messageVariables: _action_variables.urlVars,
        paramsProperty: 'updateIncidentUrl',
        buttonTitle: i18n.ADD_CASES_VARIABLE,
        showButtonTitle: true
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.updateIncidentJson",
    config: updateIncidentJsonConfig,
    component: _public.JsonFieldWrapper,
    componentProps: {
      euiCodeEditorProps: {
        height: '200px',
        isReadOnly: readOnly,
        ['aria-label']: i18n.CODE_EDITOR
      },
      dataTestSubj: 'webhookUpdateIncidentJson',
      messageVariables: [..._action_variables.casesVars, ..._action_variables.urlVars],
      paramsProperty: 'updateIncidentJson',
      buttonTitle: i18n.ADD_CASES_VARIABLE,
      showButtonTitle: true
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.STEP_4B,
    showLabel: true,
    onChange: onAddCommentToggle,
    checked: isAddCommentToggled,
    "data-test-subj": "webhookAddCommentToggle"
  }), isAddCommentToggled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.STEP_4B_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.createCommentMethod",
    component: _components.Field,
    config: createCommentMethodConfig,
    css: _update.styles.method,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookCreateCommentMethodSelect',
        options: _webhook_connectors.HTTP_VERBS.map(verb => ({
          text: verb.toUpperCase(),
          value: verb
        })),
        readOnly
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.createCommentUrl",
    config: createCommentUrlConfig,
    component: _public.MustacheTextFieldWrapper,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'webhookCreateCommentUrlText',
        messageVariables: _action_variables.urlVars,
        paramsProperty: 'createCommentUrl',
        buttonTitle: i18n.ADD_CASES_VARIABLE,
        showButtonTitle: true
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.createCommentJson",
    config: createCommentJsonConfig,
    component: _public.JsonFieldWrapper,
    componentProps: {
      euiCodeEditorProps: {
        height: '200px',
        isReadOnly: readOnly,
        ['aria-label']: i18n.CODE_EDITOR
      },
      dataTestSubj: 'webhookCreateCommentJson',
      messageVariables: [..._action_variables.commentVars, ..._action_variables.urlVars],
      paramsProperty: 'createCommentJson',
      buttonTitle: i18n.ADD_CASES_VARIABLE,
      showButtonTitle: true
    }
  }))))));
};
exports.UpdateStep = UpdateStep;