"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("../../../common/auth/constants");
var _ssl_cert_fields = require("./ssl_cert_fields");
var _basic_auth_fields = require("./basic_auth_fields");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const VERIFICATION_MODE_DEFAULT = 'full';
const AuthConfig = ({
  readOnly,
  isPfxEnabled = true
}) => {
  var _getFieldDefaultValue, _getFieldDefaultValue2;
  const {
    setFieldValue,
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.hasAuth', 'config.authType', 'config.certType', 'config.verificationMode', '__internal__.hasHeaders', '__internal__.hasCA']
  });
  const authType = config == null ? _constants.AuthType.Basic : config.authType;
  const certType = config == null ? _constants.SSLCertType.CRT : config.certType;
  const hasHeaders = __internal__ != null ? __internal__.hasHeaders : false;
  const hasCA = __internal__ != null ? __internal__.hasCA : false;
  const hasInitialCA = !!getFieldDefaultValue('config.ca');
  const hasHeadersDefaultValue = !!getFieldDefaultValue('config.headers');
  const authTypeDefaultValue = getFieldDefaultValue('config.hasAuth') === false ? null : (_getFieldDefaultValue = getFieldDefaultValue('config.authType')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : _constants.AuthType.Basic;
  const certTypeDefaultValue = (_getFieldDefaultValue2 = getFieldDefaultValue('config.certType')) !== null && _getFieldDefaultValue2 !== void 0 ? _getFieldDefaultValue2 : _constants.SSLCertType.CRT;
  const hasCADefaultValue = !!getFieldDefaultValue('config.ca') || getFieldDefaultValue('config.verificationMode') === 'none';
  (0, _react.useEffect)(() => setFieldValue('config.hasAuth', Boolean(authType)), [authType, setFieldValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.AUTHENTICATION_TITLE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.hasAuth",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.authType",
    defaultValue: authTypeDefaultValue,
    component: _components.CardRadioGroupField,
    componentProps: {
      options: [{
        value: null,
        label: i18n.AUTHENTICATION_NONE,
        'data-test-subj': 'authNone'
      }, {
        value: _constants.AuthType.Basic,
        label: i18n.AUTHENTICATION_BASIC,
        children: authType === _constants.AuthType.Basic && /*#__PURE__*/_react.default.createElement(_basic_auth_fields.BasicAuthFields, {
          readOnly: readOnly
        }),
        'data-test-subj': 'authBasic'
      }, {
        value: _constants.AuthType.SSL,
        label: i18n.AUTHENTICATION_SSL,
        children: authType === _constants.AuthType.SSL && /*#__PURE__*/_react.default.createElement(_ssl_cert_fields.SSLCertFields, {
          readOnly: readOnly,
          certTypeDefaultValue: certTypeDefaultValue,
          certType: certType,
          isPfxEnabled: isPfxEnabled
        }),
        'data-test-subj': 'authSSL'
      }]
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasHeaders",
    component: _components.ToggleField,
    config: {
      defaultValue: hasHeadersDefaultValue,
      label: i18n.HEADERS_SWITCH
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'webhookViewHeadersSwitch'
      }
    }
  }), hasHeaders && /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
    path: "config.headers",
    initialNumberOfItems: 1
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": "webhookHeaderText"
    }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.HEADERS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: item.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      path: `${item.path}.key`,
      config: {
        label: i18n.KEY_LABEL
      },
      component: _components.TextField
      // This is needed because when you delete
      // a row and add a new one, the stale values will appear
      ,
      readDefaultValueOnForm: !item.isNew,
      componentProps: {
        euiFieldProps: {
          readOnly,
          ['data-test-subj']: 'webhookHeadersKeyInput'
        }
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      path: `${item.path}.value`,
      config: {
        label: i18n.VALUE_LABEL
      },
      component: _components.TextField,
      readDefaultValueOnForm: !item.isNew,
      componentProps: {
        euiFieldProps: {
          readOnly,
          ['data-test-subj']: 'webhookHeadersValueInput'
        }
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      onClick: () => removeItem(item.id),
      iconType: "minusInCircle",
      "aria-label": i18n.DELETE_BUTTON,
      css: {
        marginTop: '28px'
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "plusInCircle",
      onClick: addItem,
      "data-test-subj": "webhookAddHeaderButton"
    }, i18n.ADD_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasCA",
    component: _components.ToggleField,
    config: {
      defaultValue: hasCADefaultValue,
      label: i18n.ADD_CA_LABEL
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'webhookViewCASwitch'
      }
    }
  }), hasCA && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.ca",
    config: {
      label: 'CA file',
      validations: [{
        validator: (config === null || config === void 0 ? void 0 : config.verificationMode) !== 'none' ? emptyField(i18n.CA_REQUIRED) : () => {}
      }]
    },
    component: _components.FilePickerField,
    componentProps: {
      euiFieldProps: {
        display: 'default',
        'data-test-subj': 'webhookCAInput',
        accept: '.ca,.pem'
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.verificationMode",
    component: _components.SelectField,
    config: {
      label: i18n.VERIFICATION_MODE_LABEL,
      defaultValue: VERIFICATION_MODE_DEFAULT,
      validations: [{
        validator: emptyField(i18n.VERIFICATION_MODE_LABEL)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookVerificationModeSelect',
        options: [{
          text: 'None',
          value: 'none'
        }, {
          text: 'Certificate',
          value: 'certificate'
        }, {
          text: 'Full',
          value: 'full'
        }],
        fullWidth: true,
        readOnly
      }
    }
  }))), hasInitialCA && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "document",
    title: i18n.EDIT_CA_CALLOUT
  }))));
};
exports.AuthConfig = AuthConfig;