"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TIMEOUT_MS = exports.DEFAULT_BEDROCK_URL = exports.DEFAULT_BEDROCK_MODEL = exports.BEDROCK_TITLE = exports.BEDROCK_CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BEDROCK_TITLE = exports.BEDROCK_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.connectorTypeTitle', {
  defaultMessage: 'Amazon Bedrock'
});
const BEDROCK_CONNECTOR_ID = exports.BEDROCK_CONNECTOR_ID = '.bedrock';
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_AI_RAW"] = "invokeAIRaw";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
  SUB_ACTION["BEDROCK_CLIENT_SEND"] = "bedrockClientSend";
  SUB_ACTION["CONVERSE"] = "converse";
  SUB_ACTION["CONVERSE_STREAM"] = "converseStream";
  return SUB_ACTION;
}({});
const DEFAULT_TIMEOUT_MS = exports.DEFAULT_TIMEOUT_MS = 200000;
const DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TOKEN_LIMIT = 8191;
const DEFAULT_BEDROCK_MODEL = exports.DEFAULT_BEDROCK_MODEL = 'us.anthropic.claude-3-7-sonnet-20250219-v1:0';
const DEFAULT_BEDROCK_URL = exports.DEFAULT_BEDROCK_URL = `https://bedrock-runtime.us-east-1.amazonaws.com`;