"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canSkipBoundariesFetch = canSkipBoundariesFetch;
exports.getShapeFilters = getShapeFilters;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _i18n = require("@kbn/i18n");
var _get_query_dsl = require("./get_query_dsl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Consider dynamically obtaining from config?
const MAX_SHAPES_QUERY_SIZE = 10000;
function canSkipBoundariesFetch(requestMeta, prevRequestMeta) {
  return prevRequestMeta ? (0, _fastDeepEqual.default)([requestMeta.geoField, requestMeta.boundaryIndexTitle, requestMeta.boundaryGeoField, requestMeta.boundaryNameField, requestMeta.boundaryIndexQuery], [prevRequestMeta.geoField, prevRequestMeta.boundaryIndexTitle, prevRequestMeta.boundaryGeoField, prevRequestMeta.boundaryNameField, prevRequestMeta.boundaryIndexQuery]) : false;
}
async function getShapeFilters(requestMeta, esClient) {
  var _boundaryData, _boundaryData$hits;
  const {
    geoField,
    boundaryIndexTitle,
    boundaryGeoField,
    boundaryNameField,
    boundaryIndexQuery
  } = requestMeta;
  let boundaryData;
  try {
    boundaryData = await esClient.search({
      index: boundaryIndexTitle,
      body: {
        size: MAX_SHAPES_QUERY_SIZE,
        _source: false,
        fields: boundaryNameField ? [boundaryNameField] : [],
        ...(boundaryIndexQuery ? {
          query: (0, _get_query_dsl.getQueryDsl)(boundaryIndexQuery)
        } : {})
      }
    });
  } catch (e) {
    throw new Error(_i18n.i18n.translate('xpack.stackAlerts.geoContainment.boundariesFetchError', {
      defaultMessage: 'Unable to fetch tracking containment boundaries, error: {error}',
      values: {
        error: e.message
      }
    }));
  }
  const hits = (_boundaryData = boundaryData) === null || _boundaryData === void 0 ? void 0 : (_boundaryData$hits = _boundaryData.hits) === null || _boundaryData$hits === void 0 ? void 0 : _boundaryData$hits.hits;
  if (!hits || hits.length === 0) {
    const noBoundariesMsg = _i18n.i18n.translate('xpack.stackAlerts.geoContainment.noBoundariesError', {
      defaultMessage: 'No tracking containtment boundaries found. Ensure index, "{index}", has documents.',
      values: {
        index: boundaryIndexTitle
      }
    });
    const adjustQueryMsg = boundaryIndexQuery ? _i18n.i18n.translate('xpack.stackAlerts.geoContainment.adjustQuery', {
      defaultMessage: 'Adjust query, "{query}" to match documents.',
      values: {
        query: boundaryIndexQuery.query
      }
    }) : null;
    throw new Error(adjustQueryMsg ? `${noBoundariesMsg} ${adjustQueryMsg}` : noBoundariesMsg);
  }
  const filters = {};
  const shapesIdsNamesMap = {};
  for (let i = 0; i < hits.length; i++) {
    const boundaryHit = hits[i];
    filters[boundaryHit._id] = {
      geo_shape: {
        [geoField]: {
          indexed_shape: {
            index: boundaryHit._index,
            id: boundaryHit._id,
            path: boundaryGeoField
          }
        }
      }
    };
    if (boundaryNameField && boundaryHit.fields && boundaryHit.fields[boundaryNameField] && boundaryHit.fields[boundaryNameField].length) {
      // fields API always returns an array, grab first value
      shapesIdsNamesMap[boundaryHit._id] = boundaryHit.fields[boundaryNameField][0];
    }
  }
  return {
    shapesFilters: filters,
    shapesIdsNamesMap
  };
}