"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BUILT_IN_ALERTS_FEATURE = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/transform-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common2 = require("@kbn/alerting-plugin/common");
var _common3 = require("@kbn/features-plugin/common");
var _rule_type = require("./rule_types/index_threshold/rule_type");
var _geo_containment = require("./rule_types/geo_containment");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TransformHealth = _common.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH;
const DISCOVER_CONSUMER = 'discover';
const basicAlertingFeatures = [_rule_type.ID, _geo_containment.GEO_CONTAINMENT_ID, TransformHealth].map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_ruleDataUtils.STACK_ALERTS_FEATURE_ID, _common2.ALERTING_FEATURE_ID]
}));

/**
 * We need to add the discover consumer
 * to support legacy ES rules that were
 * created with the discover consumer.
 *
 * Issue: https://github.com/elastic/kibana/issues/184595
 */
const esQueryAlertingFeature = {
  ruleTypeId: _ruleDataUtils.ES_QUERY_ID,
  consumers: [_ruleDataUtils.STACK_ALERTS_FEATURE_ID, _common2.ALERTING_FEATURE_ID, DISCOVER_CONSUMER]
};

/**
 * Only the stackAlerts consumer is valid
 * for the stackAlerts feature ID for the
 * xpack.ml.anomaly_detection_alert rule type.
 */
const mlAnomalyDetectionAlertingFeature = {
  ruleTypeId: _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID,
  consumers: [_ruleDataUtils.STACK_ALERTS_FEATURE_ID]
};

/**
 * Only the stackAlerts consumer is valid
 * for the stackAlerts feature ID for the
 * observability.rules.custom_threshold rule type.
 */
const observabilityThresholdAlertingFeature = {
  ruleTypeId: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
  consumers: [_ruleDataUtils.STACK_ALERTS_FEATURE_ID]
};
const alertingFeatures = [...basicAlertingFeatures, esQueryAlertingFeature, mlAnomalyDetectionAlertingFeature, observabilityThresholdAlertingFeature];
const BUILT_IN_ALERTS_FEATURE = exports.BUILT_IN_ALERTS_FEATURE = {
  id: _ruleDataUtils.STACK_ALERTS_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.stackAlerts.featureRegistry.actionsFeatureName', {
    defaultMessage: 'Stack Rules'
  }),
  app: [],
  category: _server.DEFAULT_APP_CATEGORIES.management,
  scope: [_common3.KibanaFeatureScope.Spaces, _common3.KibanaFeatureScope.Security],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: alertingFeatures,
  privileges: {
    all: {
      app: [],
      catalogue: [],
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      savedObject: {
        all: [],
        read: []
      },
      api: ['rac'],
      ui: []
    },
    read: {
      app: [],
      catalogue: [],
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          read: alertingFeatures
        }
      },
      savedObject: {
        all: [],
        read: []
      },
      api: ['rac'],
      ui: []
    }
  }
};