"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSpaceAssignedRolesTab = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _handle_api_error = require("./handle_api_error");
var _provider = require("./provider");
var _space_assign_role_privilege_form = require("./roles/component/space_assign_role_privilege_form");
var _space_assigned_roles_table = require("./roles/component/space_assigned_roles_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditSpaceAssignedRolesTab = ({
  space,
  features,
  isReadOnly
}) => {
  const {
    dispatch,
    state
  } = (0, _provider.useEditSpaceStore)(); // no loading state because roles have already been loaded
  const services = (0, _provider.useEditSpaceServices)();
  const {
    getUrlForApp,
    overlays,
    userProfile,
    theme,
    i18n: i18nStart,
    logger,
    notifications,
    invokeClient
  } = services;
  const [removeRoleConfirm, setRemoveRoleConfirm] = (0, _react.useState)(null);

  // Roles are already loaded in app state, refresh them when user navigates to this tab
  (0, _react.useEffect)(() => {
    const getRoles = async () => {
      await invokeClient(async clients => {
        let result = [];
        try {
          result = await clients.spacesManager.getRolesForSpace(space.id);
          dispatch({
            type: 'update_roles',
            payload: result
          });
        } catch (error) {
          (0, _handle_api_error.handleApiError)(error, {
            logger,
            toasts: notifications.toasts
          });
        }
      });
    };
    getRoles();
  }, [dispatch, invokeClient, space.id, logger, notifications.toasts]);
  const showRolesPrivilegeEditor = (0, _react.useCallback)(defaultSelected => {
    const overlayRef = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_provider.EditSpaceProvider, (0, _extends2.default)({}, services, {
      dispatch: dispatch,
      state: state
    }), /*#__PURE__*/_react.default.createElement(_space_assign_role_privilege_form.PrivilegesRolesForm, {
      space,
      features,
      onSaveCompleted: response => {
        const {
          updated,
          errors
        } = response;
        if (updated) {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.assignmentSuccessMsg', {
            defaultMessage: `Selected roles have been assigned to the "{spaceName}" space`,
            values: {
              spaceName: space.name
            }
          }));
        }
        for (const [roleName, error] of Object.entries(errors !== null && errors !== void 0 ? errors : {})) {
          notifications.toasts.addError(new Error(JSON.stringify(error)), {
            title: `Error updating ${roleName}`
          });
        }
        overlayRef.close();
      },
      closeFlyout: () => overlayRef.close(),
      defaultSelected,
      storeDispatch: dispatch,
      spacesClientsInvocator: invokeClient,
      getUrlForApp
    })), {
      theme,
      i18n: i18nStart,
      userProfile
    }), {
      size: 'm',
      maxWidth: true,
      maskProps: {
        headerZindexLocation: 'below'
      },
      'aria-labelledby': 'space-assign-role-privilege-form-title'
    });
  }, [overlays, services, dispatch, state, space, features, invokeClient, getUrlForApp, userProfile, theme, i18nStart, notifications.toasts]);
  const removeRole = (0, _react.useCallback)(async payload => {
    // To remove the role from the space in bulk-edit, we take the payload of roles to edit, loop over
    // each role, and modify the kibana.spaces field of each role by stripping them of the space to
    // disassociate
    const updateDoc = structuredClone(payload).map(roleDef => {
      roleDef.kibana = roleDef.kibana.filter(({
        spaces
      }) => {
        let spaceIdIndex;
        if (spaces.length && (spaceIdIndex = spaces.indexOf(space.id)) > -1) {
          if (spaces.length > 1) {
            spaces.splice(spaceIdIndex, 1);
            return true;
          } else {
            return false;
          }
        }
        return true;
      });
      return roleDef;
    });
    await invokeClient(clients => {
      return clients.rolesClient.bulkUpdateRoles({
        rolesUpdate: updateDoc
      }).then(response => {
        const {
          updated,
          errors
        } = response;
        if (updated) {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.removalSuccessMsg', {
            defaultMessage: 'Removed {count, plural, one {role} other {{count} roles}} from "{spaceName}" space',
            values: {
              spaceName: space.name,
              count: updateDoc.length
            }
          }));
        }
        for (const [roleName, error] of Object.entries(errors !== null && errors !== void 0 ? errors : {})) {
          notifications.toasts.addError(new Error(JSON.stringify(error)), {
            title: `Error updating ${roleName}`
          });
        }
      });
    });
    dispatch({
      type: 'remove_roles',
      payload: updateDoc
    });
  }, [dispatch, invokeClient, notifications.toasts, space.id, space.name]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.spaceDetails.roles.heading",
    defaultMessage: "Assign roles to this space. Users with these roles can access and use the space according to the privileges that you set."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_space_assigned_roles_table.SpaceAssignedRolesTable, {
    isReadOnly: isReadOnly,
    currentSpace: space,
    assignedRoles: state.roles,
    onClickRowEditAction: rowRecord => showRolesPrivilegeEditor([rowRecord]),
    onClickBulkRemove: async selectedRoles => {
      await removeRole(selectedRoles);
    },
    onClickRemoveRoleConfirm: async rowRecord => {
      setRemoveRoleConfirm(rowRecord);
    },
    onClickAssignNewRole: async () => {
      showRolesPrivilegeEditor();
    }
  }))), removeRoleConfirm && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": "remove-role-confirm-modal",
    titleProps: {
      id: 'remove-role-confirm-modal'
    },
    title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.removeRoleModalTitle', {
      defaultMessage: 'Remove role "{roleName}" from the space?',
      values: {
        roleName: removeRoleConfirm.name
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.removeRoleModalCancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.roles.removeRoleModalConfirm', {
      defaultMessage: 'Confirm'
    }),
    onCancel: () => setRemoveRoleConfirm(null),
    onConfirm: () => {
      removeRole([removeRoleConfirm]);
      setRemoveRoleConfirm(null);
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.spaceDetails.roles.removeRoleModalBody",
    defaultMessage: "You can't undo this operation."
  }))));
};
exports.EditSpaceAssignedRolesTab = EditSpaceAssignedRolesTab;