"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.breadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _text = require("../text");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      management: [],
      home: [],
      snapshots: [],
      repositories: [],
      policies: [],
      restore_status: [],
      repositoryAdd: [],
      repositoryEdit: [],
      restoreSnapshot: [],
      policyAdd: [],
      policyEdit: []
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;

    // Home and sections
    this.breadcrumbs.home = [{
      text: _text.textService.breadcrumbs.home,
      href: (0, _.linkToHome)()
    }];
    this.breadcrumbs.snapshots = [...this.breadcrumbs.home, {
      text: _text.textService.breadcrumbs.snapshots,
      href: (0, _.linkToSnapshots)()
    }];
    this.breadcrumbs.repositories = [...this.breadcrumbs.home, {
      text: _text.textService.breadcrumbs.repositories,
      href: (0, _.linkToRepositories)()
    }];
    this.breadcrumbs.policies = [...this.breadcrumbs.home, {
      text: _text.textService.breadcrumbs.policies,
      href: (0, _.linkToPolicies)()
    }];
    this.breadcrumbs.restore_status = [...this.breadcrumbs.home, {
      text: _text.textService.breadcrumbs.restore_status,
      href: (0, _.linkToRestoreStatus)()
    }];

    // Inner pages
    this.breadcrumbs.repositoryAdd = [...this.breadcrumbs.repositories, {
      text: _text.textService.breadcrumbs.repositoryAdd
    }];
    this.breadcrumbs.repositoryEdit = [...this.breadcrumbs.repositories, {
      text: _text.textService.breadcrumbs.repositoryEdit
    }];
    this.breadcrumbs.restoreSnapshot = [...this.breadcrumbs.snapshots, {
      text: _text.textService.breadcrumbs.restoreSnapshot
    }];
    this.breadcrumbs.policyAdd = [...this.breadcrumbs.policies, {
      text: _text.textService.breadcrumbs.policyAdd
    }];
    this.breadcrumbs.policyEdit = [...this.breadcrumbs.policies, {
      text: _text.textService.breadcrumbs.policyEdit
    }];
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error(`BreadcrumbService#setup() must be called first!`);
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];

    // Pop off last breadcrumb
    const lastBreadcrumb = newBreadcrumbs.pop();

    // Put last breadcrumb back without href
    newBreadcrumbs.push({
      ...lastBreadcrumb,
      href: undefined
    });
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
const breadcrumbService = exports.breadcrumbService = new BreadcrumbService();