"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../../../common/constants");
var _azure_details = require("./azure_details");
var _default_details = require("./default_details");
var _fs_details = require("./fs_details");
var _gcs_details = require("./gcs_details");
var _hdfs_details = require("./hdfs_details");
var _readonly_details = require("./readonly_details");
var _s3_details = require("./s3_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TypeDetails = ({
  repository
}) => {
  const {
    type,
    settings
  } = repository;
  switch (type) {
    case _constants.REPOSITORY_TYPES.fs:
      return /*#__PURE__*/_react.default.createElement(_fs_details.FSDetails, {
        repository: repository
      });
    case _constants.REPOSITORY_TYPES.url:
      return /*#__PURE__*/_react.default.createElement(_readonly_details.ReadonlyDetails, {
        repository: repository
      });
    case _constants.REPOSITORY_TYPES.source:
      const {
        delegateType
      } = settings;
      const delegatedRepository = {
        ...repository,
        type: delegateType
      };
      return /*#__PURE__*/_react.default.createElement(TypeDetails, {
        repository: delegatedRepository
      });
    case _constants.REPOSITORY_TYPES.azure:
      return /*#__PURE__*/_react.default.createElement(_azure_details.AzureDetails, {
        repository: repository
      });
    case _constants.REPOSITORY_TYPES.gcs:
      return /*#__PURE__*/_react.default.createElement(_gcs_details.GCSDetails, {
        repository: repository
      });
    case _constants.REPOSITORY_TYPES.hdfs:
      return /*#__PURE__*/_react.default.createElement(_hdfs_details.HDFSDetails, {
        repository: repository
      });
    case _constants.REPOSITORY_TYPES.s3:
      return /*#__PURE__*/_react.default.createElement(_s3_details.S3Details, {
        repository: repository
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_default_details.DefaultDetails, {
        repository: repository
      });
  }
};
exports.TypeDetails = TypeDetails;