"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("./common");
var _disable_tooltip = require("../../disable_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AzureSettings = ({
  repository,
  isManagedRepository,
  updateRepositorySettings,
  settingErrors
}) => {
  const {
    settings: {
      client,
      container,
      basePath,
      compress,
      chunkSize,
      readonly,
      locationMode,
      maxRestoreBytesPerSec,
      maxSnapshotBytesPerSec
    }
  } = repository;
  const clientId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'azureClientInput'
  });
  const containerId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'azureContainerInput'
  });
  const basePathId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'azureBasePathInput'
  });
  const hasErrors = Boolean(Object.keys(settingErrors).length);
  const locationModeOptions = ['primary_only', 'secondary_only'].map(option => ({
    value: option,
    text: option
  }));
  const updateSettings = (name, value) => {
    updateRepositorySettings({
      [name]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.clientTitle",
      defaultMessage: "Client"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.clientDescription",
      defaultMessage: "The name of the Azure client."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      id: clientId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.clientLabel",
      defaultMessage: "Client"
    })),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.client),
    error: settingErrors.client
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: isManagedRepository,
    tooltipMessage: _disable_tooltip.MANAGED_REPOSITORY_TOOLTIP_MESSAGE,
    component: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      defaultValue: client || '',
      fullWidth: true,
      onChange: e => {
        updateRepositorySettings({
          client: e.target.value
        });
      },
      "data-test-subj": "clientInput",
      disabled: isManagedRepository,
      "aria-labelledby": clientId
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.containerTitle",
      defaultMessage: "Container"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.containerDescription",
      defaultMessage: "The name of the Azure container to use for snapshots."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      id: containerId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.containerLabel",
      defaultMessage: "Container"
    })),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.container),
    error: settingErrors.container
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: isManagedRepository,
    tooltipMessage: _disable_tooltip.MANAGED_REPOSITORY_TOOLTIP_MESSAGE,
    component: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      defaultValue: container || '',
      fullWidth: true,
      onChange: e => {
        updateRepositorySettings({
          container: e.target.value
        });
      },
      "data-test-subj": "containerInput",
      disabled: isManagedRepository,
      "aria-labelledby": containerId
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.basePathTitle",
      defaultMessage: "Base path"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.basePathDescription",
      defaultMessage: "The container path to the repository data."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      id: basePathId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.basePathLabel",
      defaultMessage: "Base path"
    })),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.basePath),
    error: settingErrors.basePath
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: isManagedRepository,
    tooltipMessage: _disable_tooltip.MANAGED_REPOSITORY_TOOLTIP_MESSAGE,
    component: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      defaultValue: basePath || '',
      fullWidth: true,
      onChange: e => {
        updateRepositorySettings({
          basePath: e.target.value
        });
      },
      "data-test-subj": "basePathInput",
      disabled: isManagedRepository,
      "aria-labelledby": basePathId
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.compressTitle",
      defaultMessage: "Snapshot compression"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.compressDescription",
      defaultMessage: "Compresses the index mapping and setting files for snapshots. Data files are not compressed."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.compress),
    error: settingErrors.compress
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.compressLabel",
      defaultMessage: "Compress snapshots"
    }),
    checked: !(compress === false),
    onChange: e => {
      updateRepositorySettings({
        compress: e.target.checked
      });
    },
    "data-test-subj": "compressToggle"
  }))), /*#__PURE__*/_react.default.createElement(_common.ChunkSizeField, {
    isInvalid: Boolean(hasErrors && settingErrors.chunkSize),
    error: settingErrors.chunkSize,
    defaultValue: chunkSize || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_common.MaxSnapshotsField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxSnapshotBytesPerSec),
    error: settingErrors.maxSnapshotBytesPerSec,
    defaultValue: maxSnapshotBytesPerSec || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_common.MaxRestoreField, {
    isInvalid: Boolean(hasErrors && settingErrors.maxRestoreBytesPerSec),
    error: settingErrors.maxRestoreBytesPerSec,
    defaultValue: maxRestoreBytesPerSec || '',
    updateSettings: updateSettings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.locationModeTitle",
      defaultMessage: "Location mode"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.locationModeDescription",
      defaultMessage: "The primary or secondary location. If secondary, read-only is true."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.locationModeLabel",
      defaultMessage: "Location mode"
    }),
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.locationMode),
    error: settingErrors.locationMode
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: locationModeOptions,
    value: locationMode || locationModeOptions[0].value,
    onChange: e => {
      updateRepositorySettings({
        locationMode: e.target.value,
        readonly: e.target.value === locationModeOptions[1].value ? true : readonly
      });
    },
    fullWidth: true,
    "data-test-subj": "locationModeSelect"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.readonlyTitle",
      defaultMessage: "Read-only"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.readonlyDescription",
      defaultMessage: "Only one cluster should have write access to this repository. All other clusters should be read-only."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: Boolean(hasErrors && settingErrors.readonly),
    error: settingErrors.readonly
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: locationMode === locationModeOptions[1].value,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeAzure.readonlyLabel",
      defaultMessage: "Read-only repository"
    }),
    checked: !!readonly,
    onChange: e => {
      updateRepositorySettings({
        readonly: locationMode === locationModeOptions[1].value ? true : e.target.checked
      });
    },
    "data-test-subj": "readOnlyToggle"
  }))));
};
exports.AzureSettings = AzureSettings;