"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyStepLogistics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _constants = require("../../../constants");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _ = require("../..");
var _disable_tooltip = require("../../disable_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyStepLogistics = ({
  policy,
  updatePolicy,
  isEditing,
  currentUrl,
  errors
}) => {
  // Load repositories for repository dropdown field
  const {
    error: errorLoadingRepositories,
    isLoading: isLoadingRepositories,
    data: {
      repositories
    } = {
      repositories: []
    },
    resendRequest: reloadRepositories
  } = (0, _http.useLoadRepositories)();
  const {
    i18n,
    history
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const [showRepositoryNotFoundWarning, setShowRepositoryNotFoundWarning] = (0, _react.useState)(false);

  // State for touched inputs
  const [touched, setTouched] = (0, _react.useState)({
    name: false,
    snapshotName: false,
    repository: false,
    schedule: false
  });

  // State for cron editor
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: _constants.DEFAULT_POLICY_SCHEDULE,
    frequency: _constants.DEFAULT_POLICY_FREQUENCY
  });
  const [isAdvancedCronVisible, setIsAdvancedCronVisible] = (0, _react.useState)(Boolean(policy.schedule && policy.schedule !== _constants.DEFAULT_POLICY_SCHEDULE));
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const renderNameField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.nameDescriptionTitle",
      defaultMessage: "Policy name"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.nameDescription",
      defaultMessage: "A unique identifier for this policy."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.nameLabel",
      defaultMessage: "Name"
    }),
    isInvalid: touched.name && Boolean(errors.name),
    error: errors.name,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: policy.name,
    fullWidth: true,
    onBlur: () => setTouched({
      ...touched,
      name: true
    }),
    onChange: e => {
      updatePolicy({
        name: e.target.value
      });
    },
    placeholder: i18n.translate('xpack.snapshotRestore.policyForm.stepLogistics.namePlaceholder', {
      defaultMessage: 'daily-snapshots',
      description: 'Example SLM policy name. Similar to index names, do not use spaces in translation.'
    }),
    "data-test-subj": "nameInput",
    disabled: isEditing
  })));
  const renderRepositoryField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.repositoryDescriptionTitle",
      defaultMessage: "Repository"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.repositoryDescription",
      defaultMessage: "The repository where you want to store the snapshots."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policyRepositoryLabel",
      defaultMessage: "Repository"
    }),
    isInvalid: touched.repository && Boolean(errors.repository),
    error: errors.repository,
    fullWidth: true
  }, renderRepositorySelect()));
  const renderRepositorySelect = () => {
    if (isLoadingRepositories) {
      return /*#__PURE__*/_react.default.createElement(_.InlineLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.loadingRepositoriesDescription",
        defaultMessage: "Loading repositories\u2026"
      }));
    }
    if (errorLoadingRepositories) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.loadingRepositoriesErrorMessage",
          defaultMessage: "Error loading repositories"
        }),
        error: errorLoadingRepositories,
        actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          onClick: () => reloadRepositories(),
          color: "danger",
          iconType: "refresh",
          "data-test-subj": "reloadRepositoriesButton"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.reloadRepositoriesButtonLabel",
          defaultMessage: "Reload repositories"
        }))
      });
    }
    if (repositories.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.noRepositoriesErrorTitle",
          defaultMessage: "You don't have any repositories"
        }),
        error: {
          error: i18n.translate('xpack.snapshotRestore.policyForm.noRepositoriesErrorMessage', {
            defaultMessage: 'You must register a repository to store your snapshots.'
          })
        },
        actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddRepository)(currentUrl)), {
          color: "danger",
          iconType: "plusInCircle",
          "data-test-subj": "addRepositoryButton"
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.addRepositoryButtonLabel",
          defaultMessage: "Register a repository"
        }))
      });
    } else {
      if (!policy.repository) {
        updatePolicy({
          repository: repositories[0].name
        });
      }
    }
    const doesRepositoryExist = !!policy.repository && repositories.some(r => r.name === policy.repository);
    if (!doesRepositoryExist && !errors.repository) {
      updatePolicy(policy, {
        repositoryDoesNotExist: true
      });
    }
    if (showRepositoryNotFoundWarning !== !doesRepositoryExist) {
      setShowRepositoryNotFoundWarning(!doesRepositoryExist);
    }
    return /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
      isManaged: policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy,
      tooltipMessage: _disable_tooltip.MANAGED_POLICY_TOOLTIP_MESSAGE,
      component: /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: repositories.map(({
          name
        }) => ({
          value: name,
          text: name
        })),
        hasNoInitialSelection: !doesRepositoryExist,
        value: !doesRepositoryExist ? '' : policy.repository,
        onBlur: () => setTouched({
          ...touched,
          repository: true
        }),
        onChange: e => {
          updatePolicy({
            repository: e.target.value
          });
        },
        fullWidth: true,
        "data-test-subj": "repositorySelect",
        disabled: (policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy) && isEditing
      })
    });
  };
  const renderSnapshotNameField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.snapshotNameDescriptionTitle",
      defaultMessage: "Snapshot name"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.snapshotNameDescription",
      defaultMessage: "The name for the snapshots. A unique identifier is automatically added to each name."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameLabel",
      defaultMessage: "Snapshot name"
    }),
    isInvalid: touched.snapshotName && Boolean(errors.snapshotName),
    error: errors.snapshotName,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameHelpText",
      defaultMessage: "Supports date math expressions. {docLink}",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.date.dateMathIndexNames,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameHelpTextDocLink",
          defaultMessage: "Learn more."
        }))
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy,
    tooltipMessage: _disable_tooltip.MANAGED_POLICY_TOOLTIP_MESSAGE,
    component: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      defaultValue: policy.snapshotName,
      fullWidth: true,
      onChange: e => {
        updatePolicy({
          snapshotName: e.target.value
        });
      },
      onBlur: () => setTouched({
        ...touched,
        snapshotName: true
      }),
      placeholder: i18n.translate('xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNamePlaceholder', {
        defaultMessage: `'<daily-snap-{now/d}>'`,
        description: 'Example date math snapshot name. Keeping the same syntax is important: <SOME-TRANSLATION-{now/d}>'
      }),
      "data-test-subj": "snapshotNameInput",
      disabled: (policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy) && isEditing
    })
  })));
  const renderScheduleField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.scheduleDescriptionTitle",
      defaultMessage: "Schedule"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.scheduleDescription",
      defaultMessage: "The frequency at which to take the snapshots."
    }),
    fullWidth: true
  }, isAdvancedCronVisible ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleLabel",
      defaultMessage: "Schedule"
    }),
    isInvalid: touched.schedule && Boolean(errors.schedule),
    error: errors.schedule,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleHelpText",
      defaultMessage: "Use cron expression. {docLink}",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.apis.cronExpressions,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleHelpTextDocLink",
          defaultMessage: "Learn more."
        }))
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: policy.schedule,
    fullWidth: true,
    onChange: e => {
      updatePolicy({
        schedule: e.target.value
      });
    },
    onBlur: () => setTouched({
      ...touched,
      schedule: true
    }),
    placeholder: _constants.DEFAULT_POLICY_SCHEDULE,
    "data-test-subj": "advancedCronInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsAdvancedCronVisible(false);
      updatePolicy({
        schedule: simpleCron.expression
      });
    },
    "data-test-subj": "showBasicCronLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleButtonBasicLabel",
    defaultMessage: "Create basic interval"
  })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.CronEditor, {
    frequencyBlockList: ['MINUTE'] // ES disallows a frequency faster than 15m
    ,
    fieldToPreferredValueMap: fieldToPreferredValueMap,
    cronExpression: simpleCron.expression,
    frequency: simpleCron.frequency,
    onChange: ({
      cronExpression: expression,
      frequency,
      fieldToPreferredValueMap: newFieldToPreferredValueMap
    }) => {
      setSimpleCron({
        expression,
        frequency
      });
      setFieldToPreferredValueMap(newFieldToPreferredValueMap);
      updatePolicy({
        schedule: expression
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsAdvancedCronVisible(true);
    },
    "data-test-subj": "showAdvancedCronLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleButtonAdvancedLabel",
    defaultMessage: "Create cron expression"
  })))));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogisticsTitle",
    defaultMessage: "Logistics"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.apis.putSnapshotLifecyclePolicy,
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Logistics docs"
  })))), showRepositoryNotFoundWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "repositoryNotFoundWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.selectRepository.policyRepositoryNotFoundTitle",
      defaultMessage: "Repository not found"
    }),
    role: "alert",
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.selectRepository.policyRepositoryNotFoundDescription",
    defaultMessage: "Repository {repo} does not exist. Please select an existing repository.",
    values: {
      repo: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, policy.repository)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), renderNameField(), renderSnapshotNameField(), renderRepositoryField(), renderScheduleField());
};
exports.PolicyStepLogistics = PolicyStepLogistics;