"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGED_REPOSITORY_TOOLTIP_MESSAGE = exports.MANAGED_POLICY_TOOLTIP_MESSAGE = exports.DisableToolTip = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MANAGED_REPOSITORY_TOOLTIP_MESSAGE = exports.MANAGED_REPOSITORY_TOOLTIP_MESSAGE = _i18n.i18n.translate('xpack.snapshotRestore.repositoryForm.disableToolTip', {
  defaultMessage: 'This field is disabled because you are editing a managed repository.'
});
const MANAGED_POLICY_TOOLTIP_MESSAGE = exports.MANAGED_POLICY_TOOLTIP_MESSAGE = _i18n.i18n.translate('xpack.snapshotRestore.policyForm.disableToolTip', {
  defaultMessage: 'This field is disabled because you are editing a managed policy.'
});
/**
 * Component that wraps a given component (disabled field) with a tooltip if a repository
 * or policy is managed (isManaged === true).
 *
 * @param {boolean} isManaged - Determines if the tooltip should be displayed.
 * @param {string} tooltipMessage - The message to display inside the tooltip.
 * @param {React.ReactElement} component - The component to wrap with the tooltip.
 */
const DisableToolTip = ({
  isManaged,
  tooltipMessage,
  component
}) => {
  return isManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipMessage,
    display: "block"
  }, component) : component;
};
exports.DisableToolTip = DisableToolTip;