"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsibleFeatureStatesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _use_collapsible_list = require("./use_collapsible_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CollapsibleFeatureStatesList = ({
  featureStates
}) => {
  const {
    isShowingFullList,
    setIsShowingFullList,
    items,
    hiddenItemsCount
  } = (0, _use_collapsible_list.useCollapsibleList)({
    items: featureStates
  });
  if (items === 'all' || items.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.featureStatesList.allFeaturesLabel",
      defaultMessage: "All features"
    });
  }
  if (items.find(option => option === _constants.FEATURE_STATES_NONE_OPTION)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.featureStatesList.noneFeaturesLabel",
      defaultMessage: "No features"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "featureStatesList"
  }, items.map(feature => /*#__PURE__*/_react.default.createElement("div", {
    key: feature
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, feature))))), hiddenItemsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => isShowingFullList ? setIsShowingFullList(false) : setIsShowingFullList(true)
  }, isShowingFullList ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.featureStatesList.featureStatesCollapseAllLink",
    defaultMessage: "Hide {count, plural, one {# feature} other {# features}}",
    values: {
      count: hiddenItemsCount
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.featureStatesList.featureStatesExpandAllLink",
    defaultMessage: "Show {count, plural, one {# feature} other {# features}}",
    values: {
      count: hiddenItemsCount
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isShowingFullList ? 'arrowUp' : 'arrowDown'
  }))) : null);
};
exports.CollapsibleFeatureStatesList = CollapsibleFeatureStatesList;