"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inspectSLORoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inspectSLORoute = exports.inspectSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/_inspect',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.createSLOParamsSchema,
  handler: async ({
    context,
    params,
    logger,
    request,
    plugins,
    corePlugins,
    getScopedClients
  }) => {
    var _core$security$authc$;
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      internalSoClient,
      spaceId,
      repository,
      transformManager,
      summaryTransformManager
    } = await getScopedClients({
      request,
      logger
    });
    const core = await context.core;
    const basePath = corePlugins.http.basePath;
    const username = (_core$security$authc$ = core.security.authc.getCurrentUser()) === null || _core$security$authc$ === void 0 ? void 0 : _core$security$authc$.username;
    const createSLO = new _services.CreateSLO(scopedClusterClient, repository, internalSoClient, transformManager, summaryTransformManager, logger, spaceId, basePath, username);
    return await createSLO.inspect(params.body);
  }
});