"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloListActions = useSloListActions;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants = require("../../../embeddable/slo/overview/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSloListActions({
  slo,
  setIsAddRuleFlyoutOpen,
  setIsActionsPopoverOpen
}) {
  var _slo$remote2;
  const {
    embeddable
  } = (0, _use_kibana.useKibana)().services;
  const handleCreateRule = () => {
    setIsActionsPopoverOpen(false);
    setIsAddRuleFlyoutOpen(true);
  };
  const handleAttachToDashboardSave = (0, _react.useCallback)(({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    var _slo$remote;
    const stateTransfer = embeddable.getStateTransfer();
    const embeddableInput = {
      title: newTitle,
      description: newDescription,
      sloId: slo.id,
      sloInstanceId: slo.instanceId,
      remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
    };
    const state = {
      serializedState: {
        rawState: embeddableInput
      },
      type: _constants.SLO_OVERVIEW_EMBEDDABLE_ID
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, slo.id, slo.instanceId, (_slo$remote2 = slo.remote) === null || _slo$remote2 === void 0 ? void 0 : _slo$remote2.remoteName]);
  return {
    handleCreateRule,
    handleAttachToDashboardSave
  };
}