"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOOverviewAlerts = SLOOverviewAlerts;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_alerts_url = require("../../../../hooks/use_alerts_url");
var _use_kibana = require("../../../../hooks/use_kibana");
var _overview_item = require("./overview_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOOverviewAlerts({
  data,
  isLoading
}) {
  const {
    application,
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const locator = locators.get(_public.rulesLocatorID);
  const getAlertsUrl = (0, _use_alerts_url.useAlertsUrl)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.slo.sLOsOverview.h3.burnRateLabel', {
    defaultMessage: 'Burn rate'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.slo.sLOsOverview.lastTextLabel', {
    defaultMessage: 'Last 24h'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.burnRateActiveAlerts,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.burnRateActiveAlerts', {
      defaultMessage: 'Active alerts'
    }),
    titleColor: "danger",
    isLoading: isLoading,
    onClick: () => {
      application.navigateToUrl(getAlertsUrl('active'));
    }
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.burnRateRecoveredAlerts,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.burnRateRecoveredAlerts', {
      defaultMessage: 'Recovered alerts'
    }),
    titleColor: "success",
    isLoading: isLoading,
    onClick: () => {
      application.navigateToUrl(getAlertsUrl('recovered'));
    }
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: data === null || data === void 0 ? void 0 : data.burnRateRules,
    description: _i18n.i18n.translate('xpack.slo.sLOsOverview.euiStat.burnRateRules', {
      defaultMessage: 'Rules'
    }),
    titleColor: "default",
    isLoading: isLoading,
    onClick: () => {
      locator === null || locator === void 0 ? void 0 : locator.navigate({
        type: ['slo.rules.burnRate']
      });
    }
  })));
}