"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloList = SloList;
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _dedent = _interopRequireDefault(require("dedent"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _use_fetch_slo_list = require("../../../hooks/use_fetch_slo_list");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_url_search_state = require("../hooks/use_url_search_state");
var _group_view = require("./grouped_slos/group_view");
var _toggle_slo_view = require("./toggle_slo_view");
var _ungrouped_view = require("./ungrouped_slos/ungrouped_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloList() {
  const {
    observabilityAIAssistant
  } = (0, _use_kibana.useKibana)().services;
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    view,
    page,
    perPage,
    kqlQuery,
    filters,
    tagsFilter,
    statusFilter,
    groupBy
  } = state;
  const {
    isLoading,
    isRefetching,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    tagsFilter,
    statusFilter,
    perPage,
    filters,
    page: page + 1,
    kqlQuery,
    sortBy: state.sort.by,
    sortDirection: state.sort.direction,
    lastRefresh: state.lastRefresh
  });
  const isDeletingSlo = Boolean((0, _reactQuery.useIsMutating)(['deleteSlo']));
  (0, _react.useEffect)(() => {
    if (!sloList || !observabilityAIAssistant) {
      return;
    }
    const slosByStatus = (0, _lodash.mapValues)((0, _lodash.groupBy)(sloList.results, result => result.summary.status), groupResults => groupResults.map(result => `- ${result.name}`).join('\n'));
    return observabilityAIAssistant.service.setScreenContext({
      screenDescription: (0, _dedent.default)(`The user is looking at a list of SLOs.

      ${sloList.total >= 1 ? `There are ${sloList.total} SLOs. Out of those, ${sloList.results.length} are visible.

          Violating SLOs:
          ${slosByStatus.VIOLATED}

          Degrading SLOs:
          ${slosByStatus.DEGRADING}

          Healthy SLOs:
          ${slosByStatus.HEALTHY}

          SLOs without data:
          ${slosByStatus.NO_DATA}

          ` : ''}
      `)
    });
  }, [sloList, observabilityAIAssistant]);
  (0, _ebtTools.usePageReady)({
    isReady: !isLoading && sloList !== undefined,
    isRefreshing: isLoading
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "sloList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_toggle_slo_view.ToggleSLOView, {
    sloList: sloList,
    view: view,
    onChangeView: newView => onStateChange({
      view: newView
    }),
    onStateChange: onStateChange,
    state: state,
    loading: isLoading || isDeletingSlo
  })), groupBy === 'ungrouped' && /*#__PURE__*/_react.default.createElement(_ungrouped_view.UngroupedView, {
    sloList: sloList,
    loading: isLoading || isRefetching,
    error: isError,
    view: view
  }), groupBy !== 'ungrouped' && /*#__PURE__*/_react.default.createElement(_group_view.GroupView, {
    view: view,
    groupBy: groupBy,
    kqlQuery: kqlQuery,
    sort: state.sort.by,
    direction: state.sort.direction,
    filters: filters
  }));
}