"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenuItem = ContextMenuItem;
exports.SLOContextMenu = SLOContextMenu;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOContextMenu({
  id,
  isPopoverOpen,
  label,
  items,
  selected,
  setIsPopoverOpen,
  loading
}) {
  const singleContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'singleContextMenuPopover'
  });
  const handleTogglePopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `${id}GroupMenuButton`,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: handleTogglePopover,
    isLoading: loading
  }, selected);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "sloOverviewGroupButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: singleContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "aria-label": label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    style: {
      minWidth: 160
    }
  }))))));
}
function ContextMenuItem({
  option,
  onClosePopover
}) {
  const getIconType = checked => {
    return checked ? 'check' : 'empty';
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    size: "s",
    "aria-label": option.label,
    key: option.value,
    icon: getIconType(option.checked),
    onClick: () => {
      onClosePopover();
      option.onClick();
    }
  }, option.label);
}