"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthCallout = HealthCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _use_fetch_slo_health = require("../../../../hooks/use_fetch_slo_health");
var _use_kibana = require("../../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CALLOUT_SESSION_STORAGE_KEY = 'slo_health_callout_hidden';
function HealthCallout({
  sloList
}) {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    isLoading,
    isError,
    data: results
  } = (0, _use_fetch_slo_health.useFetchSloHealth)({
    list: sloList
  });
  const [showCallOut, setShowCallOut] = (0, _react.useState)(!sessionStorage.getItem(CALLOUT_SESSION_STORAGE_KEY));
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  if (!showCallOut) {
    return null;
  }
  if (isLoading || isError || results === undefined || (results === null || results === void 0 ? void 0 : results.length) === 0) {
    return null;
  }
  const unhealthySloList = results.filter(result => result.health.overall === 'unhealthy');
  if (unhealthySloList.length === 0) {
    return null;
  }
  const unhealthyRollupTransforms = results.filter(result => result.health.rollup === 'unhealthy');
  const unhealthySummaryTransforms = results.filter(result => result.health.summary === 'unhealthy');
  const dismiss = () => {
    setShowCallOut(false);
    sessionStorage.setItem('slo_health_callout_hidden', 'true');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    size: "s",
    onClick: e => {
      setIsOpen(!isOpen);
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.sloList.healthCallout.title",
      defaultMessage: "Transform error detected"
    })
  }, isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    onClick: e => {
      e.stopPropagation();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.description",
    defaultMessage: "The following {count, plural, one {transform is} other {transforms are} } in an unhealthy state:",
    values: {
      count: unhealthyRollupTransforms.length + unhealthySummaryTransforms.length
    }
  }), /*#__PURE__*/_react.default.createElement("ul", null, unhealthyRollupTransforms.map(result => /*#__PURE__*/_react.default.createElement("li", null, (0, _constants.getSLOTransformId)(result.sloId, result.sloRevision), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: (0, _constants.getSLOTransformId)(result.sloId, result.sloRevision)
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sloHealthCalloutCopyButton",
    "aria-label": _i18n.i18n.translate('xpack.slo.sloList.healthCallout.copyToClipboard', {
      defaultMessage: 'Copy to clipboard'
    }),
    color: "text",
    iconType: "copy",
    onClick: copy
  })))), unhealthySummaryTransforms.map(result => /*#__PURE__*/_react.default.createElement("li", null, (0, _constants.getSLOSummaryTransformId)(result.sloId, result.sloRevision), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: (0, _constants.getSLOSummaryTransformId)(result.sloId, result.sloRevision)
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sloHealthCalloutCopyButton",
    "aria-label": _i18n.i18n.translate('xpack.slo.sloList.healthCallout.copyToClipboard', {
      defaultMessage: 'Copy to clipboard'
    }),
    color: "text",
    iconType: "copy",
    onClick: copy
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloHealthCalloutInspectTransformButton",
    color: "danger",
    size: "s",
    fill: true,
    href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/data/transform')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.buttonTransformLabel",
    defaultMessage: "Inspect transform"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloHealthCalloutDimissButton",
    color: "text",
    size: "s",
    onClick: dismiss
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloList.healthCallout.buttonDimissLabel",
    defaultMessage: "Dismiss"
  }))))));
}