"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SloAddFormFlyout;
exports.sloEditFormFooterPortal = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _slo_edit_form = require("../components/slo_edit_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sloEditFormFooterPortal = exports.sloEditFormFooterPortal = (0, _reactReversePortal.createHtmlPortalNode)();

// eslint-disable-next-line import/no-default-export
function SloAddFormFlyout({
  onClose,
  initialValues
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": "flyoutSLOAddTitle",
    size: "l",
    maxWidth: 620,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "addSLOFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Create SLO",
    id: "xpack.slo.add.flyoutTitle"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_slo_edit_form.SloEditForm, {
    onSave: onClose,
    initialValues: initialValues
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
    node: sloEditFormFooterPortal
  })));
}