"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSLOsWithBurnRateRules = useFetchSLOsWithBurnRateRules;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/alerting-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchRules({
  search,
  http,
  signal
}) {
  const body = {
    search,
    fields: ['id', 'params.windows', 'name'],
    per_page: 1000,
    rule_type_ids: _ruleDataUtils.SLO_RULE_TYPE_IDS
  };
  const response = await http.post(_common.INTERNAL_ALERTING_API_FIND_RULES_PATH, {
    body: JSON.stringify({
      ...body
    }),
    signal
  });
  return response.data;
}
function useFetchSLOsWithBurnRateRules({
  search = ''
}) {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.burnRateRules(search),
    queryFn: async ({
      signal
    }) => {
      try {
        return fetchRules({
          search,
          http,
          signal
        });
      } catch (error) {
        // ignore error for retrieving slos
      }
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}