"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchApmIndex = useFetchApmIndex;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchApmIndex() {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchApmIndices'],
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.get('/internal/apm/settings/apm-index-settings', {
          signal
        });
        const metricSettings = response.apmIndexSettings.find(settings => settings.configurationName === 'metric');
        let index = '';
        if (!!metricSettings) {
          var _metricSettings$saved;
          index = (_metricSettings$saved = metricSettings.savedValue) !== null && _metricSettings$saved !== void 0 ? _metricSettings$saved : metricSettings.defaultValue;
        }
        return index;
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false
  });
  return {
    data: isInitialLoading ? '' : data !== null && data !== void 0 ? data : '',
    isLoading: isInitialLoading || isLoading || isRefetching,
    isSuccess,
    isError
  };
}