"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDisableConfirmationModal = SloDisableConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_disable_slo = require("../../../hooks/use_disable_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloDisableConfirmationModal({
  slo,
  onCancel,
  onConfirm
}) {
  const {
    mutate: disableSlo
  } = (0, _use_disable_slo.useDisableSlo)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "primary",
    "data-test-subj": "sloDisableConfirmationModal",
    title: _i18n.i18n.translate('xpack.slo.disableConfirmationModal.title', {
      defaultMessage: 'Disable {name}?',
      values: {
        name: slo.name
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.slo.disableConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.slo.disableConfirmationModal.disableButtonLabel', {
      defaultMessage: 'Disable'
    }),
    onCancel: onCancel,
    onConfirm: () => {
      disableSlo({
        id: slo.id,
        name: slo.name
      });
      onConfirm();
    }
  }, _i18n.i18n.translate('xpack.slo.disableConfirmationModal.descriptionText', {
    defaultMessage: 'Disabling this SLO will stop generating data until it is enabled again.'
  }));
}