"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenuManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _share_tabs = require("../components/share_tabs");
var _export_integrations = require("../components/export_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ShareMenuManager {
  constructor() {
    (0, _defineProperty2.default)(this, "isOpen", false);
    (0, _defineProperty2.default)(this, "container", document.createElement('div'));
    (0, _defineProperty2.default)(this, "onClose", () => {
      _reactDom.default.unmountComponentAtNode(this.container);
      this.isOpen = false;
    });
  }
  start({
    core,
    resolveShareItemsForShareContext,
    isServerless
  }) {
    return {
      /**
       * Collects share menu items from registered providers and mounts the share context menu under
       * the given `anchorElement`. If the context menu is already opened, a call to this method closes it.
       * @param options
       */
      toggleShareContextMenu: options => {
        const onClose = () => {
          var _options$onClose;
          this.onClose();
          (_options$onClose = options.onClose) === null || _options$onClose === void 0 ? void 0 : _options$onClose.call(options);
        };
        const menuItems = resolveShareItemsForShareContext({
          ...options,
          isServerless,
          onClose
        });
        this.toggleShareContextMenu({
          ...options,
          onClose,
          menuItems,
          publicAPIEnabled: !isServerless,
          ...core
        }, core.rendering);
      }
    };
  }
  toggleShareContextMenu({
    anchorElement,
    allowShortUrl,
    objectId,
    objectType,
    objectTypeMeta,
    sharingData,
    menuItems,
    shareableUrl,
    shareableUrlLocatorParams,
    onClose,
    isDirty,
    asExport,
    publicAPIEnabled
  }, rendering) {
    if (this.isOpen) {
      onClose();
      return;
    }
    document.body.appendChild(this.container);

    // initialize variable that will hold reference for unmount
    let unmount;
    const mount = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(asExport ? _export_integrations.ExportMenu : _share_tabs.ShareMenu, {
      shareContext: {
        objectId,
        objectType,
        objectTypeMeta,
        anchorElement,
        publicAPIEnabled,
        allowShortUrl,
        sharingData,
        shareableUrl,
        shareableUrlLocatorParams,
        isDirty,
        shareMenuItems: menuItems,
        onClose: () => {
          onClose();
          unmount();
        }
      }
    }), rendering);
    const openModal = () => {
      unmount = mount(this.container);
      this.isOpen = true;
    };

    // @ts-ignore openModal() returns void
    anchorElement.onclick(openModal());
  }
}
exports.ShareMenuManager = ShareMenuManager;