"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertNetworkDisplay = exports.getAlertCategoryDisplayText = void 0;
var _data_or_dash = require("./data_or_dash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertCategoryDisplayText = (alert, category) => {
  var _alert$file;
  const destination = alert === null || alert === void 0 ? void 0 : alert.destination;
  const filePath = alert === null || alert === void 0 ? void 0 : (_alert$file = alert.file) === null || _alert$file === void 0 ? void 0 : _alert$file.path;
  if (filePath && category === 'file') return (0, _data_or_dash.dataOrDash)(filePath);
  if (destination !== null && destination !== void 0 && destination.address && category === 'network') return (0, _data_or_dash.dataOrDash)(getAlertNetworkDisplay(destination));
  return '';
};
exports.getAlertCategoryDisplayText = getAlertCategoryDisplayText;
const getAlertNetworkDisplay = destination => {
  const hasIpAddressPort = !!(destination !== null && destination !== void 0 && destination.address) && !!(destination !== null && destination !== void 0 && destination.port);
  const ipAddressPort = `${destination === null || destination === void 0 ? void 0 : destination.address}:${destination === null || destination === void 0 ? void 0 : destination.port}`;
  return `${hasIpAddressPort ? ipAddressPort : destination === null || destination === void 0 ? void 0 : destination.address}`;
};
exports.getAlertNetworkDisplay = getAlertNetworkDisplay;