"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYPlayerLineMarkerType = exports.TTYPlayerControlsMarkers = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _play_head = require("./play_head");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TTYPlayerLineMarkerType = exports.TTYPlayerLineMarkerType = /*#__PURE__*/function (TTYPlayerLineMarkerType) {
  TTYPlayerLineMarkerType["ProcessChanged"] = "process_changed";
  TTYPlayerLineMarkerType["ProcessDataLimitReached"] = "data_limited";
  return TTYPlayerLineMarkerType;
}({});
const TTYPlayerControlsMarkers = ({
  processStartMarkers,
  linesLength,
  currentLine,
  onChange,
  onSeekLine
}) => {
  const progress = (0, _react.useMemo)(() => currentLine / (linesLength - 1) * 100, [currentLine, linesLength]);
  const styles = (0, _styles.useStyles)(progress);
  const markers = (0, _react.useMemo)(() => {
    if (processStartMarkers.length < 1) {
      return [];
    }
    return processStartMarkers.map(({
      event,
      line,
      maxBytesExceeded
    }) => {
      var _event$process;
      return {
        type: maxBytesExceeded ? TTYPlayerLineMarkerType.ProcessDataLimitReached : TTYPlayerLineMarkerType.ProcessChanged,
        line,
        name: (_event$process = event.process) === null || _event$process === void 0 ? void 0 : _event$process.name
      };
    });
  }, [processStartMarkers]);
  const markersLength = markers.length;
  const currentSelectedType = (0, _react.useMemo)(() => {
    if (!markersLength) {
      return undefined;
    }
    const currentSelected = currentLine >= markers[markersLength - 1].line ? markersLength - 1 : markers.findIndex(marker => marker.line > currentLine) - 1;
    return markers[Math.max(0, currentSelected)].type;
  }, [currentLine, markers, markersLength]);
  if (!markersLength) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    value: currentLine,
    min: 0,
    max: Math.max(0, linesLength - 1),
    onChange: onChange,
    fullWidth: true,
    showRange: true,
    css: styles.range
  }), /*#__PURE__*/_react.default.createElement(_play_head.PlayHead, {
    css: styles.playHead(currentSelectedType)
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.markersOverlay
  }, markers.map(({
    line,
    type,
    name
  }, idx) => {
    const selected = currentLine >= line && (idx === markersLength - 1 || currentLine < markers[idx + 1].line);

    // markers positions are absolute, setting higher z-index on the selected one in case there
    // are severals next to each other
    const markerWrapperPositioning = {
      left: `${line / (linesLength - 1) * 100}%`,
      zIndex: selected ? 3 : 2
    };
    const onMarkerClick = () => onSeekLine(line);
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx,
      style: markerWrapperPositioning,
      css: styles.markerWrapper
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: name
    }, /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      value: line,
      tabIndex: -1,
      title: type,
      css: styles.marker(type, selected),
      onClick: onMarkerClick,
      "aria-label": name
    }, name)));
  })));
};
exports.TTYPlayerControlsMarkers = TTYPlayerControlsMarkers;