"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useButtonStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useButtonStyles = () => {
  const {
    euiTheme,
    euiVars
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      border,
      colors,
      size,
      font
    } = euiTheme;
    const button = {
      lineHeight: '18px',
      height: '20px',
      fontSize: size.m,
      fontFamily: font.family,
      fontWeight: font.weight.medium,
      borderRadius: border.radius.small,
      marginLeft: size.xs,
      marginRight: size.xs,
      minWidth: 0,
      padding: `${size.s} ${size.xxs}`,
      color: euiVars.euiColorVis6_asText,
      background: (0, _eui.transparentize)(euiVars.euiColorVis6, 0.04),
      border: `${border.width.thin} solid ${(0, _eui.transparentize)(euiVars.euiColorVis6, 0.48)}`,
      '&& > span': {
        padding: `0px ${size.xxs}`,
        svg: {
          transition: `transform ${euiTheme.animation.extraFast}`
        }
      },
      '&&:hover, &&:focus': {
        background: (0, _eui.transparentize)(euiVars.euiColorVis6, 0.12),
        textDecoration: 'none'
      },
      '&.isExpanded > span svg:not(.alertIcon)': {
        transform: `rotate(180deg)`
      },
      '&.isExpanded': {
        color: colors.ghost,
        background: euiVars.euiColorVis6,
        '&:hover, &:focus': {
          background: euiVars.euiColorVis6
        }
      }
    };
    const buttonArrow = {
      marginLeft: size.xs
    };
    const alertButton = {
      ...button,
      color: euiVars.euiColorDanger,
      background: (0, _eui.transparentize)(euiVars.euiColorDanger, 0.04),
      border: `${border.width.thin} solid ${(0, _eui.transparentize)(euiVars.euiColorDanger, 0.48)}`,
      '&&:hover, &&:focus': {
        background: (0, _eui.transparentize)(euiVars.euiColorDanger, 0.12),
        textDecoration: 'none'
      },
      '&.isExpanded': {
        color: colors.ghost,
        background: euiVars.euiColorDanger,
        '&:hover, &:focus': {
          background: `${euiVars.euiColorDanger}`
        }
      },
      '& .euiButton__text': {
        display: 'flex',
        alignItems: 'center',
        ' .alertIcon': {
          marginLeft: '4px'
        }
      }
    };
    const outputButton = {
      ...button,
      color: euiVars.euiColorVis1,
      background: (0, _eui.transparentize)(euiVars.euiColorVis1, 0.04),
      border: `${border.width.thin} solid ${(0, _eui.transparentize)(euiVars.euiColorVis1, 0.48)}`,
      '&&:hover, &&:focus': {
        background: (0, _eui.transparentize)(euiVars.euiColorVis1, 0.12),
        textDecoration: 'none'
      },
      '&.isExpanded': {
        color: colors.ghost,
        background: euiVars.euiColorVis1,
        '&:hover, &:focus': {
          background: `${euiVars.euiColorVis1}`
        }
      }
    };
    const userChangedButton = {
      ...button,
      cursor: 'default',
      color: euiVars.euiColorGhost,
      background: euiVars.euiColorVis3,
      border: `${border.width.thin} solid ${(0, _eui.transparentize)(euiVars.euiColorVis3, 0.48)}`,
      '&&:hover, &&:focus': {
        color: euiVars.euiColorGhost,
        background: euiVars.euiColorVis3,
        textDecoration: 'none',
        transform: 'none',
        animation: 'none'
      }
    };
    const buttonSize = {
      padding: `0px ${euiTheme.size.xs}`
    };
    return {
      buttonArrow,
      button,
      alertButton,
      outputButton,
      userChangedButton,
      buttonSize
    };
  }, [euiTheme, euiVars]);
  return cached;
};
exports.useButtonStyles = useButtonStyles;