"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexDocumentSearch = void 0;
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGINATION = {
  from: 0,
  has_more_hits_than_total: false,
  size: 10,
  total: 0
};
const useIndexDocumentSearch = (indexName, pagination, searchQuery) => {
  var _response$data, _response$data$result, _response$data2, _response$data2$resul, _response$data2$resul2;
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const response = (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndexDocuments', pagination, searchQuery],
    queryFn: async () => http.post(`/internal/serverless_search/indices/${indexName}/search`, {
      body: JSON.stringify({
        searchQuery
      }),
      query: {
        page: pagination.pageIndex,
        size: pagination.pageSize
      }
    })
  });
  return {
    results: response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.results,
    meta: (0, _searchIndexDocuments.pageToPagination)((_response$data$result = response === null || response === void 0 ? void 0 : (_response$data2 = response.data) === null || _response$data2 === void 0 ? void 0 : (_response$data2$resul = _response$data2.results) === null || _response$data2$resul === void 0 ? void 0 : (_response$data2$resul2 = _response$data2$resul._meta) === null || _response$data2$resul2 === void 0 ? void 0 : _response$data2$resul2.page) !== null && _response$data$result !== void 0 ? _response$data$result : DEFAULT_PAGINATION)
  };
};
exports.useIndexDocumentSearch = useIndexDocumentSearch;