"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndexDetailOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../common/doc_links");
var _use_index = require("../../hooks/api/use_index");
var _badge_list = require("../badge_list");
var _overview_empty_prompt = require("./overview_empty_prompt");
var _overview_panel = require("./overview_panel");
var _index_aliases_flyout = require("./index_aliases_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexDetailOverview = ({
  index
}) => {
  var _index$data_stream;
  const [aliasesFlyoutOpen, setAliasesFlyoutOpen] = _react.default.useState(false);
  const {
    data,
    isLoading,
    isError
  } = (0, _use_index.useIndex)(index.name);
  const indexAliases = typeof index.aliases === 'string' ? index.aliases.length > 0 && index.aliases !== 'none' ? [index.aliases] : [] : index.aliases;
  if (isLoading || !data) return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.loading.title",
      defaultMessage: "Loading index"
    }))
  });
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.error.title",
        defaultMessage: "Unable to load index"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.error.description",
        defaultMessage: "There was an error loading the index."
      }))
    });
  }
  const indexData = data.index;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, aliasesFlyoutOpen && /*#__PURE__*/_react.default.createElement(_index_aliases_flyout.IndexAliasesFlyout, {
    indexName: index.name,
    aliases: indexAliases,
    onClose: () => setAliasesFlyoutOpen(false)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_panel.IndexOverviewPanel, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.dataStreamPanel.title",
      defaultMessage: "Data Stream"
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "serverlessSearchIndexDetailOverviewHowToManageDataStreamsButton",
      href: _doc_links.docLinks.dataStreams,
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.dataStreamPanel.docsLink",
      defaultMessage: "How to manage Data Streams"
    }))
  }, /*#__PURE__*/_react.default.createElement(_overview_panel.IndexOverviewPanelStat, null, (_index$data_stream = index.data_stream) !== null && _index$data_stream !== void 0 ? _index$data_stream : '--'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_panel.IndexOverviewPanel, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesPanel.title",
      defaultMessage: "Aliases"
    }),
    footer: /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
      badges: indexAliases.length > 0 ? indexAliases.map(alias => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        key: alias
      }, alias)) : [/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        key: "none"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesPanel.noneBadge",
        defaultMessage: "none"
      }))]
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_overview_panel.IndexOverviewPanelStat, null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
    value: indexAliases.length
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedPlural, {
    one: _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesPanel.singleLabel', {
      defaultMessage: 'Alias'
    }),
    other: _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesPanel.multipleLabel', {
      defaultMessage: 'Aliases'
    }),
    value: indexAliases.length
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: indexAliases.length === 0,
    "data-test-subj": "serverlessSearchIndexDetailOverviewViewAllAliasesButton",
    onClick: () => setAliasesFlyoutOpen(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.aliasesPanel.viewAllAliasesBtn",
    defaultMessage: "View All Aliases"
  }))))))), indexData.count === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_overview_empty_prompt.OverviewEmptyPrompt, {
    indexName: index.name,
    connector: indexData.connector
  })));
};

// Default Export is needed to lazy load this react component
// eslint-disable-next-line import/no-default-export
exports.IndexDetailOverview = IndexDetailOverview;
var _default = exports.default = IndexDetailOverview;