"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeRequestParams = decodeRequestParams;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _Either = require("fp-ts/lib/Either");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function decodeRequestParams(params, paramsRt) {
  // decode = validate
  const result = (0, _ioTsUtils.strictKeysRt)(paramsRt).decode(params);
  if ((0, _Either.isLeft)(result)) {
    throw _boom.default.badRequest((0, _ioTsUtils.formatErrors)(result.left));
  }
  return result.right;
}