"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setTlsConfig = void 0;
var _get_tls_options = require("./get_tls_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isTLSListener(server) {
  return 'setSecureContext' in server;
}
const setTlsConfig = (hapiServer, sslConfig) => {
  const server = hapiServer.listener;
  if (!isTLSListener(server)) {
    throw new Error('tried to set TLS config on a non-TLS http server');
  }
  const tlsOptions = (0, _get_tls_options.getServerTLSOptions)(sslConfig);
  if (!tlsOptions) {
    throw new Error('tried to apply a disabled SSL config');
  }
  server.setSecureContext(tlsOptions);
};
exports.setTlsConfig = setTlsConfig;