"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeDuration = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Types the TimeDuration as:
 *   - A string that is not empty, and composed of a positive integer greater than 0 followed by a unit of time
 *   - in the format {safe_integer}{timeUnit}, e.g. "30s", "1m", "2h", "7d"
 */

const isTimeSafe = time => time >= 1 && Number.isSafeInteger(time);
const TimeDuration = ({
  allowedUnits
}) => {
  return new t.Type('TimeDuration', t.string.is, (input, context) => {
    if (typeof input === 'string' && input.trim() !== '') {
      try {
        const inputLength = input.length;
        const time = Number(input.trim().substring(0, inputLength - 1));
        const unit = input.trim().at(-1);
        if (!isTimeSafe(time)) {
          return t.failure(input, context);
        }
        if (allowedUnits.includes(unit)) {
          return t.success(input);
        } else {
          return t.failure(input, context);
        }
      } catch (error) {
        return t.failure(input, context);
      }
    } else {
      return t.failure(input, context);
    }
  }, t.identity);
};
exports.TimeDuration = TimeDuration;