"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportExceptionListResponse = exports.ImportExceptionListRequestQuery = exports.ExceptionListsImportBulkErrorArray = exports.ExceptionListsImportBulkError = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _exception_list_common = require("../model/exception_list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Import exception list API endpoint
 *   version: 2023-10-31
 */

const ExceptionListsImportBulkError = exports.ExceptionListsImportBulkError = _zod.z.object({
  error: _zod.z.object({
    status_code: _zod.z.number().int(),
    message: _zod.z.string()
  }),
  id: _exception_list_common.ExceptionListId.optional(),
  list_id: _exception_list_common.ExceptionListHumanId.optional(),
  item_id: _exception_list_common.ExceptionListItemHumanId.optional()
});
const ExceptionListsImportBulkErrorArray = exports.ExceptionListsImportBulkErrorArray = _zod.z.array(ExceptionListsImportBulkError);
const ImportExceptionListRequestQuery = exports.ImportExceptionListRequestQuery = _zod.z.object({
  /** 
      * Determines whether existing exception lists with the same `list_id` are overwritten.
  If any exception items have the same `item_id`, those are also overwritten.
        */
  overwrite: _zodHelpers.BooleanFromString.optional().default(false),
  overwrite_exceptions: _zodHelpers.BooleanFromString.optional().default(false),
  overwrite_action_connectors: _zodHelpers.BooleanFromString.optional().default(false),
  /** 
      * Determines whether the list being imported will have a new `list_id` generated.
  Additional `item_id`'s are generated for each exception item. Both the exception
  list and its items are overwritten.
        */
  as_new_list: _zodHelpers.BooleanFromString.optional().default(false)
});
const ImportExceptionListResponse = exports.ImportExceptionListResponse = _zod.z.object({
  errors: ExceptionListsImportBulkErrorArray,
  success: _zod.z.boolean(),
  success_count: _zod.z.number().int().min(0),
  success_exception_lists: _zod.z.boolean(),
  success_count_exception_lists: _zod.z.number().int().min(0),
  success_exception_list_items: _zod.z.boolean(),
  success_count_exception_list_items: _zod.z.number().int().min(0)
});