"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsEndpointExceptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BADGE_TEXT = _i18n.i18n.translate('xpack.securitySolutionServerless.rules.endpointSecurity.endpointExceptions.badgeText', {
  defaultMessage: 'Endpoint Essentials'
});
const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolutionServerless.rules.endpointSecurity.endpointExceptions.cardTitle', {
  defaultMessage: 'Do more with Security!'
});
const CARD_MESSAGE = _i18n.i18n.translate('xpack.securitySolutionServerless.rules.endpointSecurity.endpointExceptions.cardMessage', {
  defaultMessage: 'Upgrade your license to {productTypeRequired} to use Endpoint Security Exception List.',
  values: {
    productTypeRequired: BADGE_TEXT
  }
});
const CardDescription = _styled.default.p`
  padding: 0 33.3%;
`;

/**
 * Component displayed trying to access endpoint exceptions tab on Endpoint security rule details.
 */
const RuleDetailsEndpointExceptions = exports.RuleDetailsEndpointExceptions = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "endpointPolicy-protectionsLockedCard",
    isDisabled: true,
    description: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock"
    }),
    betaBadgeProps: {
      'data-test-subj': 'rules-endpointSecurity-endpointExceptionsLockedCard-badge',
      label: BADGE_TEXT
    },
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "rules-endpointSecurity-endpointExceptionsLockedCard-title"
    }, /*#__PURE__*/_react.default.createElement("strong", null, CARD_TITLE))
  }, /*#__PURE__*/_react.default.createElement(CardDescription, null, CARD_MESSAGE));
});
RuleDetailsEndpointExceptions.displayName = 'RuleDetailsEndpointExceptions';