"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_product_type_by_pli = require("../hooks/use_product_type_by_pli");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThreatIntelligencePaywall = exports.default = /*#__PURE__*/_react.default.memo(function PaywallComponent({
  requiredPLI
}) {
  const productTypeRequired = (0, _use_product_type_by_pli.getProductTypeByPLI)(requiredPLI);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    restrictWidth: false,
    contentBorder: false,
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoSecurity",
      size: "xl"
    }),
    color: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolutionServerless.threatIntelligence.paywall.title",
      defaultMessage: "Do more with Security!"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolutionServerless.threatIntelligence.paywall.body",
      defaultMessage: "Upgrade your license to {productTypeRequired} to use threat intelligence.",
      values: {
        productTypeRequired
      }
    }))
  })));
});
ThreatIntelligencePaywall.displayName = 'ThreatIntelligencePaywall';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;