"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withServicesProvider = exports.useKibana = exports.ServicesProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServicesProvider = ({
  services,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: services
  }, children));
};
exports.ServicesProvider = ServicesProvider;
const withServicesProvider = (Component, services) => {
  return function WithServicesProvider(props) {
    return /*#__PURE__*/_react.default.createElement(ServicesProvider, {
      services: services
    }, /*#__PURE__*/_react.default.createElement(Component, props));
  };
};
exports.withServicesProvider = withServicesProvider;
const useKibana = () => (0, _public.useKibana)();
exports.useKibana = useKibana;