"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLI_PRODUCT_FEATURES = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _product = require("../product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLI_PRODUCT_FEATURES = exports.PLI_PRODUCT_FEATURES = {
  [_product.ProductLine.aiSoc]: {
    search_ai_lake: [_keys.ProductFeatureKey.attackDiscovery, _keys.ProductFeatureKey.assistant, _keys.ProductFeatureKey.configurations, _keys.ProductFeatureKey.externalDetections, _keys.ProductFeatureKey.externalRuleActions],
    // neither of these tiers are available in ai_soc product line
    essentials: [],
    complete: []
  },
  [_product.ProductLine.security]: {
    search_ai_lake: [],
    essentials: [_keys.ProductFeatureKey.detections, _keys.ProductFeatureKey.timeline, _keys.ProductFeatureKey.notes, _keys.ProductFeatureKey.endpointHostManagement, _keys.ProductFeatureKey.endpointPolicyManagement, _keys.ProductFeatureKey.endpointHostIsolation],
    complete: [_keys.ProductFeatureKey.detections, _keys.ProductFeatureKey.timeline, _keys.ProductFeatureKey.notes, _keys.ProductFeatureKey.endpointHostManagement, _keys.ProductFeatureKey.endpointPolicyManagement, _keys.ProductFeatureKey.endpointHostIsolation, _keys.ProductFeatureKey.advancedInsights, _keys.ProductFeatureKey.assistant, _keys.ProductFeatureKey.attackDiscovery, _keys.ProductFeatureKey.investigationGuide, _keys.ProductFeatureKey.investigationGuideInteractions, _keys.ProductFeatureKey.threatIntelligence, _keys.ProductFeatureKey.casesConnectors, _keys.ProductFeatureKey.externalRuleActions, _keys.ProductFeatureKey.integrationAssistant, _keys.ProductFeatureKey.prebuiltRuleCustomization, _keys.ProductFeatureKey.siemMigrations]
  },
  [_product.ProductLine.endpoint]: {
    search_ai_lake: [],
    // endpoint add-on not available in search_ai_lake tier
    essentials: [_keys.ProductFeatureKey.endpointPolicyProtections, _keys.ProductFeatureKey.endpointArtifactManagement, _keys.ProductFeatureKey.endpointExceptions],
    complete: [_keys.ProductFeatureKey.endpointPolicyProtections, _keys.ProductFeatureKey.endpointArtifactManagement, _keys.ProductFeatureKey.endpointExceptions, _keys.ProductFeatureKey.endpointHostIsolationExceptions, _keys.ProductFeatureKey.endpointResponseActions, _keys.ProductFeatureKey.osqueryAutomatedResponseActions, _keys.ProductFeatureKey.endpointAgentTamperProtection, _keys.ProductFeatureKey.endpointCustomNotification, _keys.ProductFeatureKey.endpointProtectionUpdates, _keys.ProductFeatureKey.securityWorkflowInsights]
  },
  [_product.ProductLine.cloud]: {
    search_ai_lake: [],
    // cloud add-on not available in search_ai_lake tier
    essentials: [_keys.ProductFeatureKey.cloudSecurityPosture],
    complete: [_keys.ProductFeatureKey.cloudSecurityPosture]
  }
};