"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskMetricsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _helpers = require("./helpers");
var _types = require("./types");
var _configuration = require("./configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TaskMetricsService {
  constructor(logger, sender) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.sender = sender;
    this.logger = (0, _helpers.newTelemetryLogger)(logger.get('telemetry_events.task_metrics'));
  }
  start(name) {
    return {
      name,
      startedAt: performance.now()
    };
  }
  async end(trace, error) {
    const event = this.createTaskMetric(trace, error);
    this.logger.debug('Task completed', {
      task_name: event.name,
      time_executed_in_ms: event.time_executed_in_ms,
      error_message: event.error_message
    });
    if (_configuration.telemetryConfiguration.use_async_sender) {
      this.sender.sendAsync(_types.TelemetryChannel.TASK_METRICS, [event]);
    } else {
      await this.sender.sendOnDemand(_types.TelemetryChannel.TASK_METRICS, [event]);
    }
  }
  createTaskMetric(trace, error) {
    const finishedAt = performance.now();
    return {
      name: trace.name,
      passed: error === undefined,
      time_executed_in_ms: finishedAt - trace.startedAt,
      start_time: trace.startedAt,
      end_time: finishedAt,
      error_message: error === null || error === void 0 ? void 0 : error.message
    };
  }
}
exports.TaskMetricsService = TaskMetricsService;