"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.events = exports.createAssetCriticalityProcessedFileEvent = exports.TELEMETRY_NODE_INGEST_PIPELINES_STATS_EVENT = exports.TELEMETRY_INDEX_TEMPLATES_EVENT = exports.TELEMETRY_INDEX_STATS_EVENT = exports.TELEMETRY_INDEX_SETTINGS_EVENT = exports.TELEMETRY_ILM_STATS_EVENT = exports.TELEMETRY_ILM_POLICY_EVENT = exports.TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_STATS_EVENT = exports.TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_RESULT_EVENT = exports.TELEMETRY_DATA_STREAM_EVENT = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE = exports.SIEM_MIGRATIONS_PREBUILT_RULES_MATCH = exports.SIEM_MIGRATIONS_MIGRATION_SUCCESS = exports.SIEM_MIGRATIONS_MIGRATION_FAILURE = exports.SIEM_MIGRATIONS_MIGRATION_ABORTED = exports.SIEM_MIGRATIONS_INTEGRATIONS_MATCH = exports.RISK_SCORE_EXECUTION_SUCCESS_EVENT = exports.RISK_SCORE_EXECUTION_ERROR_EVENT = exports.RISK_SCORE_EXECUTION_CANCELLATION_EVENT = exports.GAP_DETECTED_EVENT = exports.FIELD_RETENTION_ENRICH_POLICY_EXECUTION_EVENT = exports.ENTITY_STORE_USAGE_EVENT = exports.ENTITY_STORE_DATA_VIEW_REFRESH_EXECUTION_EVENT = exports.ENTITY_ENGINE_RESOURCE_INIT_FAILURE_EVENT = exports.ENTITY_ENGINE_INITIALIZATION_EVENT = exports.ENDPOINT_RESPONSE_ACTION_STATUS_CHANGE_EVENT = exports.ENDPOINT_RESPONSE_ACTION_SENT_EVENT = exports.ENDPOINT_RESPONSE_ACTION_SENT_ERROR_EVENT = exports.ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT = exports.ALERT_SUPPRESSION_EVENT = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_SCORE_EXECUTION_SUCCESS_EVENT = exports.RISK_SCORE_EXECUTION_SUCCESS_EVENT = {
  eventType: 'risk_score_execution_success',
  schema: {
    scoresWritten: {
      type: 'long',
      _meta: {
        description: 'Number of risk scores written during this scoring task execution'
      }
    },
    taskDurationInSeconds: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the current risk scoring task execution'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: `Configured interval for the current risk scoring task`
      }
    },
    alertSampleSizePerShard: {
      type: 'long',
      _meta: {
        description: `Number of alerts to sample per shard for the current risk scoring task`
      }
    }
  }
};
const RISK_SCORE_EXECUTION_ERROR_EVENT = exports.RISK_SCORE_EXECUTION_ERROR_EVENT = {
  eventType: 'risk_score_execution_error',
  schema: {}
};
const RISK_SCORE_EXECUTION_CANCELLATION_EVENT = exports.RISK_SCORE_EXECUTION_CANCELLATION_EVENT = {
  eventType: 'risk_score_execution_cancellation',
  schema: {
    scoresWritten: {
      type: 'long',
      _meta: {
        description: 'Number of risk scores written during this scoring task execution'
      }
    },
    taskDurationInSeconds: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the current risk scoring task execution'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: `Configured interval for the current risk scoring task`
      }
    },
    alertSampleSizePerShard: {
      type: 'long',
      _meta: {
        description: `Number of alerts to sample per shard for the current risk scoring task`
      }
    }
  }
};
const ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT = exports.ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT = {
  eventType: 'Asset Criticality Csv Upload Processed',
  schema: {
    processing: {
      properties: {
        startTime: {
          type: 'date',
          _meta: {
            description: 'Processing start time'
          }
        },
        endTime: {
          type: 'date',
          _meta: {
            description: 'Processing end time'
          }
        },
        tookMs: {
          type: 'long',
          _meta: {
            description: 'How long processing took ms'
          }
        }
      }
    },
    result: {
      properties: {
        successful: {
          type: 'long',
          _meta: {
            description: 'Number of criticality records successfully created or updated'
          }
        },
        failed: {
          type: 'long',
          _meta: {
            description: 'Number of criticality records which had errors'
          }
        },
        total: {
          type: 'long',
          _meta: {
            description: 'Total number of lines in the file'
          }
        }
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'Status of the processing either success, partial_success or fail'
      }
    }
  }
};
const FIELD_RETENTION_ENRICH_POLICY_EXECUTION_EVENT = exports.FIELD_RETENTION_ENRICH_POLICY_EXECUTION_EVENT = {
  eventType: 'field_retention_enrich_policy_execution',
  schema: {
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the field retention enrich policy execution time'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: 'Configured interval for the field retention enrich policy task'
      }
    }
  }
};
const ENTITY_STORE_DATA_VIEW_REFRESH_EXECUTION_EVENT = exports.ENTITY_STORE_DATA_VIEW_REFRESH_EXECUTION_EVENT = {
  eventType: 'entity_store_data_view_refresh_execution_event',
  schema: {
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the entity store data view refresh execution time'
      }
    },
    interval: {
      type: 'keyword',
      _meta: {
        description: 'Configured interval for the entity store data view refresh task'
      }
    }
  }
};
const ENTITY_ENGINE_RESOURCE_INIT_FAILURE_EVENT = exports.ENTITY_ENGINE_RESOURCE_INIT_FAILURE_EVENT = {
  eventType: 'entity_engine_resource_init_failure',
  schema: {
    error: {
      type: 'keyword',
      _meta: {
        description: 'Error message for a resource initialization failure'
      }
    }
  }
};
const ENTITY_ENGINE_INITIALIZATION_EVENT = exports.ENTITY_ENGINE_INITIALIZATION_EVENT = {
  eventType: 'entity_engine_initialization',
  schema: {
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration (in seconds) of the entity engine initialization'
      }
    }
  }
};
const ENTITY_STORE_USAGE_EVENT = exports.ENTITY_STORE_USAGE_EVENT = {
  eventType: 'entity_store_usage',
  schema: {
    storeSize: {
      type: 'long',
      _meta: {
        description: 'Number of entities stored in the entity store'
      }
    }
  }
};
const ALERT_SUPPRESSION_EVENT = exports.ALERT_SUPPRESSION_EVENT = {
  eventType: 'alert_suppression_on_rule_execution',
  schema: {
    suppressionAlertsCreated: {
      type: 'long',
      _meta: {
        description: 'Number of alerts created during rule execution with configured alert suppression'
      }
    },
    suppressionAlertsSuppressed: {
      type: 'long',
      _meta: {
        description: 'Number of alerts suppressed during rule execution with configured alert suppression'
      }
    },
    suppressionRuleName: {
      type: 'keyword',
      _meta: {
        description: 'Name of rule'
      }
    },
    suppressionDuration: {
      type: 'long',
      _meta: {
        description: 'Duration in seconds of suppression period. -1 for per rule execution config'
      }
    },
    suppressionGroupByFieldsNumber: {
      type: 'long',
      _meta: {
        description: 'Number of Suppress by fields'
      }
    },
    suppressionGroupByFields: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'Tag attached to the element...',
          optional: false
        }
      },
      _meta: {
        description: 'List of tags attached to the element...',
        optional: false
      }
    },
    suppressionRuleType: {
      type: 'keyword',
      _meta: {
        description: 'Rule type'
      }
    },
    suppressionMissingFields: {
      type: 'boolean',
      _meta: {
        description: 'Suppression of missing fields enabled'
      }
    },
    suppressionRuleId: {
      type: 'keyword',
      _meta: {
        description: 'ruleId'
      }
    }
  }
};
const TELEMETRY_DATA_STREAM_EVENT = exports.TELEMETRY_DATA_STREAM_EVENT = {
  eventType: 'telemetry_data_stream_event',
  schema: {
    items: {
      type: 'array',
      items: {
        properties: {
          datastream_name: {
            type: 'keyword',
            _meta: {
              description: 'Name of the data stream'
            }
          },
          ilm_policy: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'ILM policy associated to the datastream'
            }
          },
          template: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Template associated to the datastream'
            }
          },
          indices: {
            type: 'array',
            items: {
              properties: {
                index_name: {
                  type: 'date',
                  _meta: {
                    description: 'Index name'
                  }
                },
                ilm_policy: {
                  type: 'date',
                  _meta: {
                    optional: true,
                    description: 'ILM policy'
                  }
                }
              }
            },
            _meta: {
              optional: true,
              description: 'Indices associated with the data stream'
            }
          }
        }
      },
      _meta: {
        description: 'Datastream settings'
      }
    }
  }
};
const TELEMETRY_INDEX_STATS_EVENT = exports.TELEMETRY_INDEX_STATS_EVENT = {
  eventType: 'telemetry_index_stats_event',
  schema: {
    items: {
      type: 'array',
      items: {
        properties: {
          index_name: {
            type: 'keyword',
            _meta: {
              description: 'The name of the index being monitored.'
            }
          },
          query_total: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of search queries executed on the index.'
            }
          },
          query_time_in_millis: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total time spent on query execution across all search requests, measured in milliseconds.'
            }
          },
          docs_count_primaries: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of documents currently stored in the index (primary shards).'
            }
          },
          docs_deleted_primaries: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of documents that have been marked as deleted in the index (primary shards).'
            }
          },
          docs_total_size_in_bytes_primaries: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total size, in bytes, of all documents stored in the index, including storage overhead (primary shards).'
            }
          },
          docs_count: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of documents currently stored in the index (primary and replica shards).'
            }
          },
          docs_deleted: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of documents that have been marked as deleted in the index (primary and replica shards).'
            }
          },
          docs_total_size_in_bytes: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total size, in bytes, of all documents stored in the index, including storage overhead (primary and replica shards).'
            }
          },
          index_failed: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of documents failed to index (primary and replica shards).'
            }
          },
          index_failed_due_to_version_conflict: {
            type: 'long',
            _meta: {
              optional: true,
              description: 'The total number of documents failed to index due to version conflict (primary and replica shards).'
            }
          }
        }
      },
      _meta: {
        description: 'Index stats'
      }
    }
  }
};
const TELEMETRY_INDEX_SETTINGS_EVENT = exports.TELEMETRY_INDEX_SETTINGS_EVENT = {
  eventType: 'telemetry_index_settings_event',
  schema: {
    items: {
      type: 'array',
      items: {
        properties: {
          index_name: {
            type: 'keyword',
            _meta: {
              description: 'The name of the index.'
            }
          },
          index_mode: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Index mode.'
            }
          },
          source_mode: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Source mode.'
            }
          },
          default_pipeline: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Pipeline applied if no pipeline parameter specified when indexing.'
            }
          },
          final_pipeline: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Pipeline applied to the document at the end of the indexing process, after the document has been indexed.'
            }
          }
        }
      },
      _meta: {
        description: 'Index settings'
      }
    }
  }
};
const TELEMETRY_ILM_POLICY_EVENT = exports.TELEMETRY_ILM_POLICY_EVENT = {
  eventType: 'telemetry_ilm_policy_event',
  schema: {
    items: {
      type: 'array',
      items: {
        properties: {
          policy_name: {
            type: 'keyword',
            _meta: {
              description: 'The name of the ILM policy.'
            }
          },
          modified_date: {
            type: 'date',
            _meta: {
              description: 'The date when the ILM policy was last modified.'
            }
          },
          phases: {
            properties: {
              cold: {
                properties: {
                  min_age: {
                    type: 'text',
                    _meta: {
                      description: 'The minimum age before the index transitions to the "cold" phase.'
                    }
                  }
                },
                _meta: {
                  optional: true,
                  description: 'Configuration settings for the "cold" phase of the ILM policy, applied when data is infrequently accessed.'
                }
              },
              delete: {
                properties: {
                  min_age: {
                    type: 'text',
                    _meta: {
                      description: 'The minimum age before the index transitions to the "delete" phase.'
                    }
                  }
                },
                _meta: {
                  optional: true,
                  description: 'Configuration settings for the "delete" phase of the ILM policy, specifying when the index should be removed.'
                }
              },
              frozen: {
                properties: {
                  min_age: {
                    type: 'text',
                    _meta: {
                      description: 'The minimum age before the index transitions to the "frozen" phase.'
                    }
                  }
                },
                _meta: {
                  optional: true,
                  description: 'Configuration settings for the "frozen" phase of the ILM policy, where data is fully searchable but stored with a reduced resource footprint.'
                }
              },
              hot: {
                properties: {
                  min_age: {
                    type: 'text',
                    _meta: {
                      description: 'The minimum age before the index transitions to the "hot" phase.'
                    }
                  }
                },
                _meta: {
                  optional: true,
                  description: 'Configuration settings for the "hot" phase of the ILM policy, applied to actively written and queried data.'
                }
              },
              warm: {
                properties: {
                  min_age: {
                    type: 'text',
                    _meta: {
                      description: 'The minimum age before the index transitions to the "warm" phase.'
                    }
                  }
                },
                _meta: {
                  optional: true,
                  description: 'Configuration settings for the "warm" phase of the ILM policy, used for read-only data that is less frequently accessed.'
                }
              }
            },
            _meta: {
              description: 'The different phases of the ILM policy that define how the index is managed over time.'
            }
          }
        }
      },
      _meta: {
        description: 'ILM policies'
      }
    }
  }
};
const TELEMETRY_ILM_STATS_EVENT = exports.TELEMETRY_ILM_STATS_EVENT = {
  eventType: 'telemetry_ilm_stats_event',
  schema: {
    items: {
      type: 'array',
      items: {
        properties: {
          index_name: {
            type: 'keyword',
            _meta: {
              description: 'The name of the index currently managed by the ILM  policy.'
            }
          },
          phase: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'The current phase of the ILM policy that the index is in (e.g., hot, warm, cold, frozen, or delete).'
            }
          },
          age: {
            type: 'text',
            _meta: {
              optional: true,
              description: 'The age of the index since its creation, indicating how long it has existed.'
            }
          },
          policy_name: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'The name of the ILM policy applied to this index.'
            }
          }
        }
      },
      _meta: {
        description: 'ILM stats'
      }
    }
  }
};
const TELEMETRY_INDEX_TEMPLATES_EVENT = exports.TELEMETRY_INDEX_TEMPLATES_EVENT = {
  eventType: 'telemetry_index_templates_event',
  schema: {
    items: {
      type: 'array',
      items: {
        properties: {
          template_name: {
            type: 'keyword',
            _meta: {
              description: 'The name of the template.'
            }
          },
          index_mode: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'The index mode.'
            }
          },
          datastream: {
            type: 'boolean',
            _meta: {
              description: 'Datastream dataset'
            }
          },
          package_name: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'The package name'
            }
          },
          managed_by: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Managed by'
            }
          },
          beat: {
            type: 'keyword',
            _meta: {
              optional: true,
              description: 'Shipper name'
            }
          },
          is_managed: {
            type: 'boolean',
            _meta: {
              optional: true,
              description: 'Whether the template is managed'
            }
          },
          composed_of: {
            type: 'array',
            items: {
              type: 'keyword',
              _meta: {
                description: 'List of template components'
              }
            },
            _meta: {
              description: ''
            }
          },
          source_enabled: {
            type: 'boolean',
            _meta: {
              optional: true,
              description: 'The _source field contains the original JSON document body that was provided at index time'
            }
          },
          source_includes: {
            type: 'array',
            items: {
              type: 'keyword',
              _meta: {
                description: 'Fields included in _source, if enabled'
              }
            },
            _meta: {
              description: ''
            }
          },
          source_excludes: {
            type: 'array',
            items: {
              type: 'keyword',
              _meta: {
                description: ''
              }
            },
            _meta: {
              description: 'Fields excludes from _source, if enabled'
            }
          }
        }
      },
      _meta: {
        description: 'Index templates info'
      }
    }
  }
};
const TELEMETRY_NODE_INGEST_PIPELINES_STATS_EVENT = exports.TELEMETRY_NODE_INGEST_PIPELINES_STATS_EVENT = {
  eventType: 'telemetry_node_ingest_pipelines_stats_event',
  schema: {
    name: {
      type: 'keyword',
      _meta: {
        description: 'The name of the node'
      }
    },
    pipelines: {
      type: 'array',
      items: {
        properties: {
          name: {
            type: 'keyword',
            _meta: {
              description: 'The name of the pipeline.'
            }
          },
          totals: {
            properties: {
              count: {
                type: 'long',
                _meta: {
                  description: 'Total number of documents ingested during the lifetime of this node.'
                }
              },
              time_in_millis: {
                type: 'long',
                _meta: {
                  description: 'Ingestion elapsed time during the lifetime of this node.'
                }
              },
              current: {
                type: 'long',
                _meta: {
                  description: 'Total number of documents currently being ingested.'
                }
              },
              failed: {
                type: 'long',
                _meta: {
                  description: 'Total number of failed ingest operations during the lifetime of this node.'
                }
              }
            }
          },
          processors: {
            type: 'array',
            items: {
              properties: {
                name: {
                  type: 'keyword',
                  _meta: {
                    description: 'The name of the pipeline.'
                  }
                },
                totals: {
                  properties: {
                    count: {
                      type: 'long',
                      _meta: {
                        description: 'Total number of documents ingested during the lifetime of this node.'
                      }
                    },
                    time_in_millis: {
                      type: 'long',
                      _meta: {
                        description: 'Ingestion elapsed time during the lifetime of this node.'
                      }
                    },
                    current: {
                      type: 'long',
                      _meta: {
                        description: 'Total number of documents currently being ingested.'
                      }
                    },
                    failed: {
                      type: 'long',
                      _meta: {
                        description: 'Total number of failed ingest operations during the lifetime of this node.'
                      }
                    }
                  }
                }
              },
              _meta: {
                description: 'Datastreams'
              }
            }
          }
        },
        _meta: {
          description: 'Datastreams'
        }
      }
    },
    totals: {
      properties: {
        count: {
          type: 'long',
          _meta: {
            description: 'Total number of documents ingested during the lifetime of this node.'
          }
        },
        time_in_millis: {
          type: 'long',
          _meta: {
            description: 'Ingestion elapsed time during the lifetime of this node.'
          }
        },
        current: {
          type: 'long',
          _meta: {
            description: 'Total number of documents currently being ingested.'
          }
        },
        failed: {
          type: 'long',
          _meta: {
            description: 'Total number of failed ingest operations during the lifetime of this node.'
          }
        }
      }
    }
  }
};
const TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_RESULT_EVENT = exports.TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_RESULT_EVENT = {
  eventType: 'telemetry_health_diagnostic_query_result_event',
  schema: {
    name: {
      type: 'keyword',
      _meta: {
        description: 'Identifier for the executed query.'
      }
    },
    queryId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the specific query.'
      }
    },
    traceId: {
      type: 'keyword',
      _meta: {
        description: 'Unique trace ID for correlating a single query execution.'
      }
    },
    page: {
      type: 'integer',
      _meta: {
        description: 'Page number of the query result.'
      }
    },
    data: {
      type: 'pass_through',
      _meta: {
        description: 'Raw query result payload.'
      }
    }
  }
};
const TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_STATS_EVENT = exports.TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_STATS_EVENT = {
  eventType: 'telemetry_health_diagnostic_query_stats_event',
  schema: {
    name: {
      type: 'keyword',
      _meta: {
        description: 'Identifier for the executed query.'
      }
    },
    traceId: {
      type: 'keyword',
      _meta: {
        description: 'Unique trace ID for correlating a single query execution.'
      }
    },
    numDocs: {
      type: 'integer',
      _meta: {
        description: 'Number of documents returned by the query.'
      }
    },
    passed: {
      type: 'boolean',
      _meta: {
        description: 'Indicates whether the query completed successfully.'
      }
    },
    started: {
      type: 'keyword',
      _meta: {
        description: 'When the query started execution.'
      }
    },
    finished: {
      type: 'keyword',
      _meta: {
        description: 'When the query finished execution.'
      }
    },
    failure: {
      properties: {
        message: {
          type: 'keyword',
          _meta: {
            description: 'A high-level failure message describing the error.'
          }
        },
        reason: {
          properties: {
            circuitBreaker: {
              type: 'keyword',
              _meta: {
                description: 'The name of the circuit breaker that triggered the failure.'
              }
            },
            valid: {
              type: 'boolean',
              _meta: {
                description: 'Indicates whether the query execution was considered valid.'
              }
            },
            message: {
              type: 'keyword',
              _meta: {
                optional: true,
                description: 'A detailed reason or message explaining why the circuit breaker was triggered.'
              }
            }
          }
        }
      },
      _meta: {
        optional: true,
        description: 'Details about the failure if the operation was unsuccessful.'
      }
    },
    fieldNames: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'Field names in the query result.'
        }
      }
    },
    circuitBreakers: {
      type: 'pass_through',
      _meta: {
        optional: true,
        description: 'Circuit breaker metrics such as execution time and memory usage.'
      }
    }
  }
};
const createAssetCriticalityProcessedFileEvent = ({
  result,
  startTime,
  endTime
}) => {
  const status = getUploadStatus(result);
  const processing = {
    startTime: startTime.toISOString(),
    endTime: endTime.toISOString(),
    tookMs: endTime.getTime() - startTime.getTime()
  };
  return [ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT.eventType, {
    processing,
    result,
    status
  }];
};
exports.createAssetCriticalityProcessedFileEvent = createAssetCriticalityProcessedFileEvent;
const getUploadStatus = stats => {
  if (!stats) {
    return 'fail';
  }
  if (stats.failed === 0) {
    return 'success';
  }
  if (stats.successful > 0) {
    return 'partial_success';
  }
  return 'fail';
};
const ENDPOINT_RESPONSE_ACTION_SENT_ERROR_EVENT = exports.ENDPOINT_RESPONSE_ACTION_SENT_ERROR_EVENT = {
  eventType: 'endpoint_response_action_sent_error',
  schema: {
    responseActions: {
      properties: {
        agentType: {
          type: 'keyword',
          _meta: {
            description: 'The type of agent that the action was sent to',
            optional: false
          }
        },
        command: {
          type: 'keyword',
          _meta: {
            description: 'The command that was sent to the endpoint',
            optional: false
          }
        },
        error: {
          type: 'text',
          _meta: {
            description: 'The error message for the response action'
          }
        }
      }
    }
  }
};
const ENDPOINT_RESPONSE_ACTION_SENT_EVENT = exports.ENDPOINT_RESPONSE_ACTION_SENT_EVENT = {
  eventType: 'endpoint_response_action_sent',
  schema: {
    responseActions: {
      properties: {
        actionId: {
          type: 'keyword',
          _meta: {
            description: 'The ID of the action that was sent to the endpoint',
            optional: false
          }
        },
        agentType: {
          type: 'keyword',
          _meta: {
            description: 'The type of agent that the action was sent to',
            optional: false
          }
        },
        command: {
          type: 'keyword',
          _meta: {
            description: 'The command that was sent to the endpoint',
            optional: false
          }
        },
        isAutomated: {
          type: 'boolean',
          _meta: {
            description: 'Whether the action was auto-initiated by a pre-configured rule',
            optional: false
          }
        }
      }
    }
  }
};
const ENDPOINT_RESPONSE_ACTION_STATUS_CHANGE_EVENT = exports.ENDPOINT_RESPONSE_ACTION_STATUS_CHANGE_EVENT = {
  eventType: 'endpoint_response_action_status_change_event',
  schema: {
    responseActions: {
      properties: {
        actionId: {
          type: 'keyword',
          _meta: {
            description: 'The ID of the action that was sent to the endpoint',
            optional: false
          }
        },
        agentType: {
          type: 'keyword',
          _meta: {
            description: 'The type of agent that the action was sent to',
            optional: false
          }
        },
        actionStatus: {
          type: 'keyword',
          _meta: {
            description: 'The status of the action',
            optional: false
          }
        },
        command: {
          type: 'keyword',
          _meta: {
            description: 'The command that was sent to the endpoint',
            optional: false
          }
        }
      }
    }
  }
};
const SIEM_MIGRATIONS_MIGRATION_SUCCESS = exports.SIEM_MIGRATIONS_MIGRATION_SUCCESS = {
  eventType: _types.SiemMigrationsEventTypes.MigrationSuccess,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    completed: {
      type: 'long',
      _meta: {
        description: 'Number of rules successfully migrated'
      }
    },
    failed: {
      type: 'long',
      _meta: {
        description: 'Number of rules that failed to migrate'
      }
    },
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of rules to migrate'
      }
    }
  }
};
const SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS = {
  eventType: _types.SiemMigrationsEventTypes.TranslationSuccess,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    translationResult: {
      type: 'keyword',
      _meta: {
        description: 'Describes if the translation was full or partial'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    prebuiltMatch: {
      type: 'boolean',
      _meta: {
        description: 'Whether a prebuilt rule was matched'
      }
    }
  }
};
const SIEM_MIGRATIONS_PREBUILT_RULES_MATCH = exports.SIEM_MIGRATIONS_PREBUILT_RULES_MATCH = {
  eventType: _types.SiemMigrationsEventTypes.PrebuiltRulesMatch,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    preFilterRuleNames: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'List of matched rules from Semantic search before LLM filtering'
        }
      }
    },
    preFilterRuleCount: {
      type: 'long',
      _meta: {
        description: 'Count of rules matched before LLM filtering'
      }
    },
    postFilterRuleName: {
      type: 'keyword',
      _meta: {
        description: 'List of matched rules from Semantic search after LLM filtering'
      }
    },
    postFilterRuleCount: {
      type: 'long',
      _meta: {
        description: 'Count of rules matched before LLM filtering'
      }
    }
  }
};
const SIEM_MIGRATIONS_INTEGRATIONS_MATCH = exports.SIEM_MIGRATIONS_INTEGRATIONS_MATCH = {
  eventType: _types.SiemMigrationsEventTypes.IntegrationsMatch,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    preFilterIntegrationNames: {
      type: 'array',
      items: {
        type: 'keyword',
        _meta: {
          description: 'List of matched integrations from Semantic search before LLM filtering'
        }
      }
    },
    preFilterIntegrationCount: {
      type: 'long',
      _meta: {
        description: 'Count of integrations matched before LLM filtering'
      }
    },
    postFilterIntegrationName: {
      type: 'keyword',
      _meta: {
        description: 'List of matched integrations from Semantic search after LLM filtering'
      }
    },
    postFilterIntegrationCount: {
      type: 'long',
      _meta: {
        description: 'Count of integrations matched before LLM filtering'
      }
    }
  }
};
const SIEM_MIGRATIONS_MIGRATION_FAILURE = exports.SIEM_MIGRATIONS_MIGRATION_FAILURE = {
  eventType: _types.SiemMigrationsEventTypes.MigrationFailure,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    error: {
      type: 'keyword',
      _meta: {
        description: 'Error message for the migration failure'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    completed: {
      type: 'long',
      _meta: {
        description: 'Number of rules successfully migrated'
      }
    },
    failed: {
      type: 'long',
      _meta: {
        description: 'Number of rules that failed to migrate'
      }
    },
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of rules to migrate'
      }
    }
  }
};
const SIEM_MIGRATIONS_MIGRATION_ABORTED = exports.SIEM_MIGRATIONS_MIGRATION_ABORTED = {
  eventType: _types.SiemMigrationsEventTypes.MigrationAborted,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    reason: {
      type: 'keyword',
      _meta: {
        description: 'The reason of the migration abort'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    },
    duration: {
      type: 'long',
      _meta: {
        description: 'Duration of the migration in milliseconds'
      }
    },
    completed: {
      type: 'long',
      _meta: {
        description: 'Number of rules successfully migrated'
      }
    },
    failed: {
      type: 'long',
      _meta: {
        description: 'Number of rules that failed to migrate'
      }
    },
    total: {
      type: 'long',
      _meta: {
        description: 'Total number of rules to migrate'
      }
    }
  }
};
const SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE = exports.SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE = {
  eventType: _types.SiemMigrationsEventTypes.TranslationFailure,
  schema: {
    eventName: {
      type: 'keyword',
      _meta: {
        description: 'The event name/description',
        optional: false
      }
    },
    error: {
      type: 'keyword',
      _meta: {
        description: 'Error message for the translation failure'
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'The LLM model that was used'
      }
    },
    migrationId: {
      type: 'keyword',
      _meta: {
        description: 'Unique identifier for the migration'
      }
    }
  }
};
const GAP_DETECTED_EVENT = exports.GAP_DETECTED_EVENT = {
  eventType: 'gap_detected_event',
  schema: {
    gapDuration: {
      type: 'long',
      _meta: {
        description: 'The duration of the gap'
      }
    },
    intervalDuration: {
      type: 'long',
      _meta: {
        description: 'The duration of the interval'
      }
    },
    intervalAndLookbackDuration: {
      type: 'long',
      _meta: {
        description: 'The duration of the interval and lookback'
      }
    },
    ruleType: {
      type: 'keyword',
      _meta: {
        description: 'The type of the rule'
      }
    },
    ruleSource: {
      type: 'keyword',
      _meta: {
        description: 'The source of the rule'
      }
    },
    isCustomized: {
      type: 'boolean',
      _meta: {
        description: 'Whether the prebuilt rule is customized'
      }
    }
  }
};
const events = exports.events = [RISK_SCORE_EXECUTION_SUCCESS_EVENT, RISK_SCORE_EXECUTION_ERROR_EVENT, RISK_SCORE_EXECUTION_CANCELLATION_EVENT, ASSET_CRITICALITY_SYSTEM_PROCESSED_ASSIGNMENT_FILE_EVENT, ALERT_SUPPRESSION_EVENT, ENDPOINT_RESPONSE_ACTION_SENT_EVENT, ENDPOINT_RESPONSE_ACTION_SENT_ERROR_EVENT, ENDPOINT_RESPONSE_ACTION_STATUS_CHANGE_EVENT, FIELD_RETENTION_ENRICH_POLICY_EXECUTION_EVENT, ENTITY_STORE_DATA_VIEW_REFRESH_EXECUTION_EVENT, ENTITY_ENGINE_RESOURCE_INIT_FAILURE_EVENT, ENTITY_ENGINE_INITIALIZATION_EVENT, ENTITY_STORE_USAGE_EVENT, TELEMETRY_DATA_STREAM_EVENT, TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_RESULT_EVENT, TELEMETRY_HEALTH_DIAGNOSTIC_QUERY_STATS_EVENT, TELEMETRY_ILM_POLICY_EVENT, TELEMETRY_ILM_STATS_EVENT, TELEMETRY_INDEX_SETTINGS_EVENT, TELEMETRY_INDEX_STATS_EVENT, TELEMETRY_INDEX_TEMPLATES_EVENT, TELEMETRY_NODE_INGEST_PIPELINES_STATS_EVENT, SIEM_MIGRATIONS_MIGRATION_SUCCESS, SIEM_MIGRATIONS_MIGRATION_ABORTED, SIEM_MIGRATIONS_MIGRATION_FAILURE, SIEM_MIGRATIONS_RULE_TRANSLATION_SUCCESS, SIEM_MIGRATIONS_RULE_TRANSLATION_FAILURE, SIEM_MIGRATIONS_PREBUILT_RULES_MATCH, SIEM_MIGRATIONS_INTEGRATIONS_MATCH, GAP_DETECTED_EVENT];