"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyFilterlist = applyFilterlist;
exports.emptyStat = emptyStat;
exports.fieldNames = fieldNames;
exports.parseDiagnosticQueries = parseDiagnosticQueries;
exports.shouldExecute = shouldExecute;
var _crypto = require("crypto");
var YAML = _interopRequireWildcard(require("yaml"));
var _intervals = require("@kbn/task-manager-plugin/server/lib/intervals");
var _health_diagnostic_service = require("./health_diagnostic_service.types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function shouldExecute(startDate, endDate, interval) {
  const nextDate = (0, _intervals.intervalFromDate)(startDate, interval);
  return nextDate !== undefined && nextDate < endDate;
}
function parseDiagnosticQueries(input) {
  return YAML.parseAllDocuments(input).map(doc => {
    return doc.toJSON();
  });
}
function fieldNames(documents) {
  const result = new Set();
  const traverse = (obj, path) => {
    if (Array.isArray(obj)) {
      if (obj.length > 0) {
        traverse(obj[0], `${path}[]`);
      } else {
        result.add(`${path}[]`);
      }
    } else if (obj && typeof obj === 'object') {
      for (const [key, value] of Object.entries(obj)) {
        traverse(value, path ? `${path}.${key}` : key);
      }
    } else {
      result.add(path);
    }
  };
  traverse(documents, '');
  return Array.from(result);
}
function emptyStat(name, now) {
  return {
    name,
    started: now.toISOString(),
    traceId: (0, _crypto.randomUUID)(),
    finished: new Date().toISOString(),
    numDocs: 0,
    passed: false,
    fieldNames: []
  };
}
async function applyFilterlist(data, rules, salt) {
  const filteredResult = [];
  const applyFilterToDoc = async doc => {
    const filteredDoc = {};
    for (const path of Object.keys(rules)) {
      const keys = path.split('.');
      await processPath(doc, filteredDoc, keys, path, 0);
    }
    return filteredDoc;
  };
  const processPath = async (src, dst, keys, fullPath, keyIndex) => {
    if (keyIndex >= keys.length || !src || typeof src !== 'object') return;
    const key = keys[keyIndex];
    const srcObj = src;
    if (!Object.hasOwn(srcObj, key)) return;
    if (keyIndex === keys.length - 1) {
      const value = srcObj[key];
      dst[key] = rules[fullPath] === _health_diagnostic_service.Action.MASK ? await maskValue(String(value), salt) : value;
    } else {
      const nextValue = srcObj[key];
      if (Array.isArray(nextValue)) {
        if (!dst[key]) {
          dst[key] = [];
        }
        const dstArray = dst[key];
        for (let i = 0; i < nextValue.length; i++) {
          const item = nextValue[i];
          if (item && typeof item === 'object') {
            if (!dstArray[i]) {
              dstArray[i] = {};
            }
            await processPath(item, dstArray[i], keys, fullPath, keyIndex + 1);
          }
        }
      } else if (nextValue && typeof nextValue === 'object') {
        dst[key] ??= {};
        await processPath(nextValue, dst[key], keys, fullPath, keyIndex + 1);
      }
    }
  };
  for (const doc of data) {
    if (Array.isArray(doc)) {
      const docs = doc;
      const result = await Promise.all(docs.map(d => {
        return applyFilterToDoc(d);
      }));
      filteredResult.push(result);
    } else {
      filteredResult.push(await applyFilterToDoc(doc));
    }
  }
  return filteredResult;
}
async function maskValue(value, salt) {
  const encoder = new TextEncoder();
  const data = encoder.encode(salt + value);
  const hashBuffer = await crypto.subtle.digest('SHA-256', data);
  const hashArray = Array.from(new Uint8Array(hashBuffer));
  return hashArray.map(b => b.toString(16).padStart(2, '0')).join('');
}