"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslateRuleNode = void 0;
var _comments = require("../../../../../util/comments");
var _prompts = require("./prompts");
var _severity = require("./severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTranslateRuleNode = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async state => {
    var _state$integration, _state$integration$da, _response$match$1$tri, _response$match, _response$match$, _response$match2, _state$integration2;
    const indexPatterns = ((_state$integration = state.integration) === null || _state$integration === void 0 ? void 0 : (_state$integration$da = _state$integration.data_streams) === null || _state$integration$da === void 0 ? void 0 : _state$integration$da.map(dataStream => dataStream.index_pattern).join(',')) || 'logs-*';
    const splunkRule = {
      title: state.original_rule.title,
      description: state.original_rule.description,
      inline_query: state.inline_query
    };
    const prompt = await _prompts.ESQL_SYNTAX_TRANSLATION_PROMPT.format({
      splunk_rule: JSON.stringify(splunkRule, null, 2),
      indexPatterns
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    const esqlQuery = (_response$match$1$tri = (_response$match = response.match(/```esql\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1].trim()) !== null && _response$match$1$tri !== void 0 ? _response$match$1$tri : '';
    if (!esqlQuery) {
      logger.warn('Failed to extract ESQL query from translation response');
      const comment = '## Translation Summary\n\nFailed to extract ESQL query from translation response';
      return {
        comments: [(0, _comments.generateAssistantComment)(comment)]
      };
    }
    const translationSummary = (_response$match$ = (_response$match2 = response.match(/## Translation Summary[\s\S]*$/)) === null || _response$match2 === void 0 ? void 0 : _response$match2[0]) !== null && _response$match$ !== void 0 ? _response$match$ : '';
    return {
      comments: [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(translationSummary))],
      elastic_rule: {
        query: esqlQuery,
        query_language: 'esql',
        risk_score: (0, _severity.getElasticRiskScoreFromOriginalRule)(state.original_rule),
        severity: (0, _severity.getElasticSeverityFromOriginalRule)(state.original_rule),
        ...(((_state$integration2 = state.integration) === null || _state$integration2 === void 0 ? void 0 : _state$integration2.id) && {
          integration_ids: [state.integration.id]
        })
      }
    };
  };
};
exports.getTranslateRuleNode = getTranslateRuleNode;