"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMatchPrebuiltRuleNode = void 0;
var _output_parsers = require("@langchain/core/output_parsers");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
var _comments = require("../../../util/comments");
var _prompts = require("./prompts");
var _constants2 = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMatchPrebuiltRuleNode = ({
  model,
  ruleMigrationsRetriever,
  telemetryClient,
  logger
}) => {
  return async state => {
    var _state$original_rule$;
    const query = state.semantic_query;
    const techniqueIds = ((_state$original_rule$ = state.original_rule.annotations) === null || _state$original_rule$ === void 0 ? void 0 : _state$original_rule$.mitre_attack) || [];
    const prebuiltRules = await ruleMigrationsRetriever.prebuiltRules.search(query, techniqueIds.join(','));
    if (prebuiltRules.length === 0) {
      telemetryClient.reportPrebuiltRulesMatch({
        preFilterRules: []
      });
      return {
        comments: [(0, _comments.generateAssistantComment)('## Prebuilt Rule Matching Summary\nNo related prebuilt rule found.')]
      };
    }
    const outputParser = new _output_parsers.JsonOutputParser();
    const mostRelevantRule = _prompts.MATCH_PREBUILT_RULE_PROMPT.pipe(model).pipe(outputParser);
    const elasticSecurityRules = prebuiltRules.map(rule => {
      var _rule$target, _rule$target2;
      return {
        name: rule.name,
        description: rule.description,
        query: ((_rule$target = rule.target) === null || _rule$target === void 0 ? void 0 : _rule$target.type) !== 'machine_learning' ? (_rule$target2 = rule.target) === null || _rule$target2 === void 0 ? void 0 : _rule$target2.query : ''
      };
    });
    const splunkRule = {
      title: state.original_rule.title,
      description: state.original_rule.description,
      query: state.original_rule.query
    };

    /*
     * Takes the most relevant rule from the array of rule(s) returned by the semantic query, returns either the most relevant or none.
     */
    const response = await mostRelevantRule.invoke({
      rules: JSON.stringify(elasticSecurityRules, null, 2),
      splunk_rule: JSON.stringify(splunkRule, null, 2)
    });
    const comments = response.summary ? [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(response.summary))] : undefined;
    if (response.match) {
      const matchedRule = prebuiltRules.find(r => r.name === response.match);
      telemetryClient.reportPrebuiltRulesMatch({
        preFilterRules: prebuiltRules,
        postFilterRule: matchedRule
      });
      if (matchedRule) {
        var _matchedRule$current, _matchedRule$target, _matchedRule$target$r, _matchedRule$target$s, _matchedRule$target2, _matchedRule$target$r2, _matchedRule$target3;
        return {
          comments,
          elastic_rule: {
            title: matchedRule.name,
            description: matchedRule.description,
            prebuilt_rule_id: matchedRule.rule_id,
            id: (_matchedRule$current = matchedRule.current) === null || _matchedRule$current === void 0 ? void 0 : _matchedRule$current.id,
            integration_ids: (_matchedRule$target = matchedRule.target) === null || _matchedRule$target === void 0 ? void 0 : (_matchedRule$target$r = _matchedRule$target.related_integrations) === null || _matchedRule$target$r === void 0 ? void 0 : _matchedRule$target$r.map(i => i.package),
            severity: (_matchedRule$target$s = (_matchedRule$target2 = matchedRule.target) === null || _matchedRule$target2 === void 0 ? void 0 : _matchedRule$target2.severity) !== null && _matchedRule$target$s !== void 0 ? _matchedRule$target$s : _constants2.DEFAULT_TRANSLATION_SEVERITY,
            risk_score: (_matchedRule$target$r2 = (_matchedRule$target3 = matchedRule.target) === null || _matchedRule$target3 === void 0 ? void 0 : _matchedRule$target3.risk_score) !== null && _matchedRule$target$r2 !== void 0 ? _matchedRule$target$r2 : _constants2.DEFAULT_TRANSLATION_RISK_SCORE
          },
          translation_result: _constants.RuleTranslationResult.FULL
        };
      }
    }
    return {
      comments
    };
  };
};
exports.getMatchPrebuiltRuleNode = getMatchPrebuiltRuleNode;