"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableEntityStoreRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _validation = require("./validation");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../../asset_criticality/check_and_init_asset_criticality_resources");
var _enable = require("../../../../../common/api/entity_analytics/entity_store/enable.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enableEntityStoreRoute = (router, logger, config) => {
  router.versioned.post({
    access: 'public',
    path: '/api/entity_store/enable',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _validation.buildInitRequestBodyValidation)(_enable.InitEntityStoreRequestBody)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    const {
      pipelineDebugMode
    } = config.entityAnalytics.entityStore.developer;
    await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
    try {
      const body = await secSol.getEntityStoreDataClient().enable(request.body, {
        pipelineDebugMode
      });
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error initialising entity store: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.enableEntityStoreRoute = enableEntityStoreRoute;