"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEngineDescription = void 0;
var _fp = require("lodash/fp");
var _elasticsearch_assets = require("../elasticsearch_assets");
var _entity_descriptions = require("../entity_definitions/entity_descriptions");
var _utils = require("../utils");
var _merge = require("../../../../../common/utils/objects/merge");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const engineDescriptionRegistry = {
  host: _entity_descriptions.hostEntityEngineDescription,
  user: _entity_descriptions.userEntityEngineDescription,
  service: _entity_descriptions.serviceEntityEngineDescription
};
const createEngineDescription = params => {
  const {
    entityType,
    namespace,
    config,
    requestParams = {},
    defaultIndexPatterns
  } = params;
  const fileConfig = {
    delay: `${config.syncDelay.asSeconds()}s`,
    frequency: `${config.frequency.asSeconds()}s`
  };
  const options = (0, _merge.merge)(_constants.defaultOptions, (0, _merge.merge)(fileConfig, requestParams));
  const indexPatterns = (0, _utils.mergeEntityStoreIndices)(defaultIndexPatterns, options.indexPattern);
  const description = engineDescriptionRegistry[entityType];
  const settings = {
    syncDelay: options.delay,
    timeout: options.timeout,
    frequency: options.frequency,
    docsPerSecond: options.docsPerSecond,
    lookbackPeriod: options.lookbackPeriod,
    timestampField: options.timestampField
  };
  const defaults = {
    ...description,
    id: (0, _utils.buildEntityDefinitionId)(entityType, namespace),
    settings: (0, _fp.assign)(settings, description.settings),
    indexPatterns: (0, _fp.concat)(indexPatterns, description.indexPatterns || []),
    fields: description.fields.map((0, _merge.merge)({
      retention: {
        maxLength: options.fieldHistoryLength
      },
      aggregation: {
        limit: options.fieldHistoryLength
      }
    })),
    dynamic: description.dynamic || false
  };
  const updatedDescription = {
    ...defaults,
    indexMappings: (0, _elasticsearch_assets.generateIndexMappings)(defaults)
  };
  return updatedDescription;
};
exports.createEngineDescription = createEngineDescription;