"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.preferOldestValueProcessor = void 0;
var _painless = require("../painless");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A field retention operator that prefers the oldest value of the specified field.
 * If the historical field is missing or empty, the latest value is used.
 */
const preferOldestValueProcessor = ({
  destination
}, {
  enrichField
}) => {
  const historicalField = `${enrichField}.${destination}`;
  return {
    set: {
      if: `!(${(0, _painless.isFieldMissingOrEmpty)(`ctx.${historicalField}`)})`,
      field: destination,
      value: `{{${historicalField}}}`
    }
  };
};
exports.preferOldestValueProcessor = preferOldestValueProcessor;