"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapSuppressedEsqlAlerts = void 0;
var _lodash = require("lodash");
var _objectHash = _interopRequireDefault(require("object-hash"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reason_formatters = require("../utils/reason_formatters");
var _transform_hit_to_alert = require("../factories/utils/transform_hit_to_alert");
var _utils = require("../utils");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapSuppressedEsqlAlerts = ({
  sharedParams,
  events,
  isRuleAggregating,
  expandedFields
}) => {
  const {
    spaceId,
    completeRule,
    tuple,
    primaryTimestamp,
    secondaryTimestamp
  } = sharedParams;
  const wrapped = events.map((event, i) => {
    var _completeRule$rulePar, _event$_index;
    const combinedFields = {
      ...(event === null || event === void 0 ? void 0 : event.fields),
      ...event._source
    };
    const suppressionTerms = (0, _utils.getSuppressionTerms)({
      alertSuppression: completeRule === null || completeRule === void 0 ? void 0 : (_completeRule$rulePar = completeRule.ruleParams) === null || _completeRule$rulePar === void 0 ? void 0 : _completeRule$rulePar.alertSuppression,
      input: combinedFields
    });
    const id = (0, _utils2.generateAlertId)({
      event,
      spaceId,
      completeRule,
      tuple,
      isRuleAggregating,
      index: i,
      expandedFields
    });
    const instanceId = (0, _objectHash.default)([suppressionTerms, completeRule.alertId, spaceId]);
    const baseAlert = (0, _transform_hit_to_alert.transformHitToAlert)({
      sharedParams,
      doc: event,
      applyOverrides: true,
      buildReasonMessage: _reason_formatters.buildReasonMessageForNewTermsAlert,
      alertUuid: id
    });
    return {
      _id: id,
      _index: (_event$_index = event._index) !== null && _event$_index !== void 0 ? _event$_index : '',
      _source: {
        ...baseAlert,
        ...(0, _utils.getSuppressionAlertFields)({
          primaryTimestamp,
          secondaryTimestamp,
          fields: combinedFields,
          suppressionTerms,
          fallbackTimestamp: baseAlert[_ruleDataUtils.TIMESTAMP],
          instanceId
        })
      }
    };
  });
  return (0, _lodash.uniqBy)(wrapped, alert => alert._id);
};
exports.wrapSuppressedEsqlAlerts = wrapSuppressedEsqlAlerts;