"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkPatchRulesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../../common/constants");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _utils = require("../../../../routes/utils");
var _utils2 = require("../../../utils/utils");
var _read_rules = require("../../../logic/detection_rules_client/read_rules");
var _deprecation = require("../../deprecation");
var _validate_rule_default_exception_list = require("../../../logic/exceptions/validate_rule_default_exception_list");
var _validate_rules_with_duplicated_default_exceptions_list = require("../../../logic/exceptions/validate_rules_with_duplicated_default_exceptions_list");
var _timeouts = require("../../timeouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated since version 8.2.0. Use the detection_engine/rules/_bulk_action API instead
 */
const bulkPatchRulesRoute = (router, logger, docLinks) => {
  const securityDocLinks = docLinks.links.securitySolution;
  router.versioned.patch({
    access: 'public',
    path: _constants.DETECTION_ENGINE_RULES_BULK_UPDATE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      timeout: {
        idleSocket: _timeouts.RULE_MANAGEMENT_BULK_ACTION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_management.BulkPatchRulesRequestBody)
      }
    },
    options: {
      deprecated: {
        documentationUrl: securityDocLinks.legacyRuleManagementBulkApiDeprecations,
        severity: 'warning',
        reason: {
          type: 'migrate',
          newApiMethod: 'POST',
          newApiPath: _constants.DETECTION_ENGINE_RULES_BULK_ACTION
        }
      }
    }
  }, async (context, request, response) => {
    (0, _deprecation.logDeprecatedBulkEndpoint)(logger, _constants.DETECTION_ENGINE_RULES_BULK_UPDATE);
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'securitySolution', 'alerting', 'licensing']);
      const rulesClient = await ctx.alerting.getRulesClient();
      const detectionRulesClient = ctx.securitySolution.getDetectionRulesClient();
      const rules = await Promise.all(request.body.map(async payloadRule => {
        var _ref, _payloadRule$id;
        const idOrRuleIdOrUnknown = (_ref = (_payloadRule$id = payloadRule.id) !== null && _payloadRule$id !== void 0 ? _payloadRule$id : payloadRule.rule_id) !== null && _ref !== void 0 ? _ref : '(unknown id)';
        try {
          const existingRule = await (0, _read_rules.readRules)({
            rulesClient,
            ruleId: payloadRule.rule_id,
            id: payloadRule.id
          });
          if (!existingRule) {
            return (0, _utils2.getIdBulkError)({
              id: payloadRule.id,
              ruleId: payloadRule.rule_id
            });
          }
          (0, _validate_rules_with_duplicated_default_exceptions_list.validateRulesWithDuplicatedDefaultExceptionsList)({
            allRules: request.body,
            exceptionsList: payloadRule.exceptions_list,
            ruleId: idOrRuleIdOrUnknown
          });
          await (0, _validate_rule_default_exception_list.validateRuleDefaultExceptionList)({
            exceptionsList: payloadRule.exceptions_list,
            rulesClient,
            ruleRuleId: payloadRule.rule_id,
            ruleId: payloadRule.id
          });
          const patchedRule = await detectionRulesClient.patchRule({
            rulePatch: payloadRule
          });
          return patchedRule;
        } catch (err) {
          return (0, _utils.transformBulkError)(idOrRuleIdOrUnknown, err);
        }
      }));
      return response.ok({
        body: _rule_management.BulkCrudRulesResponse.parse(rules),
        headers: (0, _deprecation.getDeprecatedBulkEndpointHeader)(_constants.DETECTION_ENGINE_RULES_BULK_UPDATE)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        headers: (0, _deprecation.getDeprecatedBulkEndpointHeader)(_constants.DETECTION_ENGINE_RULES_BULK_UPDATE),
        statusCode: error.statusCode
      });
    }
  });
};
exports.bulkPatchRulesRoute = bulkPatchRulesRoute;